/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.dragome.commons.javascript.ScriptHelper;
import java.util.Calendar;
import java.util.Date;

public final class String
implements CharSequence,
Comparable<String> {
    private static void consume(String me) {
    }

    public String() {
        String.consume("");
    }

    public String(String value) {
        String.consume(value.toString());
    }

    public String(char[] data) {
        String.consume(String.valueOf(data));
    }

    public String(char[] data, int offset, int count) {
        String.consume(String.valueOf(data, offset, count));
    }

    private static String init(byte[] bytes, int offset, int count, String enc) {
        char[] chars = new char[count];
        for (int i = 0; i < count; ++i) {
            chars[i] = (char)bytes[offset + i];
        }
        return String.valueOf(chars);
    }

    public String(byte[] bytes, int offset, int count, String enc) {
        String.consume(String.init(bytes, offset, count, enc));
    }

    public String(byte[] bytes, String enc) {
        String.consume(String.init(bytes, 0, bytes.length, enc));
    }

    public String(byte[] bytes, int offset, int count) {
        String.consume(String.init(bytes, offset, count, null));
    }

    public String(byte[] bytes) {
        String.consume(String.init(bytes, 0, bytes.length, null));
    }

    public String(StringBuffer buffer) {
        String.consume(buffer.toString());
    }

    @Override
    public int length() {
        return ScriptHelper.evalInt((String)"this.length", (Object)this);
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        ScriptHelper.put((String)"index", (double)index, (Object)this);
        return ScriptHelper.evalChar((String)"this.charCodeAt(index)", (Object)this);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[i - srcBegin + dstBegin] = this.charAt(i);
        }
    }

    public byte[] getBytes(String enc) {
        return this.getBytes();
    }

    public byte[] getBytes() {
        byte[] data = new byte[this.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)this.charAt(i);
        }
        return data;
    }

    public boolean equals(Object obj) {
        ScriptHelper.put((String)"obj", (Object)obj, (Object)this);
        return ScriptHelper.evalBoolean((String)"String(this) == String(obj)", (Object)this);
    }

    public boolean equalsIgnoreCase(String other) {
        if (other == null) {
            return false;
        }
        ScriptHelper.put((String)"other", (Object)other, (Object)this);
        return ScriptHelper.evalBoolean((String)"this.toLowerCase() == other.toLowerCase()", (Object)this);
    }

    @Override
    public int compareTo(String other) {
        ScriptHelper.put((String)"other", (Object)other, (Object)this);
        return ScriptHelper.evalInt((String)"this<other?-1:(this>other?1:0)", (Object)this);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        if (ignoreCase) {
            return this.substring(toffset).equalsIgnoreCase(other.substring(ooffset));
        }
        return this.substring(toffset).equals(other.substring(ooffset));
    }

    public boolean startsWith(String prefix, int offset) {
        return this.substring(offset, prefix.length()).equals(prefix);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.substring(this.length() - suffix.length()).equals(suffix);
    }

    private static String leftPadding(int width, int number) {
        String sign = "";
        if (number < 0) {
            sign = "-";
            number = -number;
        }
        String s = String.valueOf(number);
        for (int i = 0; i < width - s.length(); ++i) {
            s = "0" + s;
        }
        return sign + s;
    }

    public static String format(String format, Object ... args) {
        StringBuilder sb = new StringBuilder();
        String[] parts = format.split("%");
        sb.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            String[] daysOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
            String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dez"};
            String part = parts[i];
            int j = part.indexOf("$");
            int argIndex = Integer.parseInt(part.substring(0, j));
            Object arg = args[argIndex - 1];
            char type = part.charAt(j + 1);
            char conv = part.charAt(j + 2);
            String chunk = null;
            if (type == 't') {
                Date d = (Date)arg;
                Calendar cal = Calendar.getInstance();
                cal.setTime(d);
                if (conv == 'a') {
                    chunk = daysOfWeek[cal.get(7) - 1];
                } else if (conv == 'd') {
                    chunk = String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
                } else if (conv == 'b') {
                    chunk = months[cal.get(Calendar.MONTH)];
                } else if (conv == 'Y') {
                    chunk = String.leftPadding(4, cal.get(Calendar.YEAR));
                } else if (conv == 'H') {
                    chunk = String.leftPadding(2, cal.get(Calendar.HOUR_OF_DAY));
                } else if (conv == 'M') {
                    chunk = String.leftPadding(2, cal.get(Calendar.MINUTE));
                } else if (conv == 'S') {
                    chunk = String.leftPadding(2, cal.get(Calendar.SECOND));
                } else if (conv == 'z') {
                    chunk = String.leftPadding(4, cal.get(Calendar.ZONE_OFFSET));
                } else if (conv == 'T') {
                    chunk = String.format("%1$tH:%1$tM:%1$tS", d);
                }
            }
            if (chunk == null) {
                throw new RuntimeException("Illegal format at: " + part);
            }
            sb.append(chunk);
            sb.append(part.substring(j + 3));
        }
        return sb.toString();
    }

    public int hashCode() {
        return ScriptHelper.evalInt((String)"this.split(\"\").reduce(function(a,b){a=((a<<5)-a)+b.charCodeAt(0);return a&a},0)", (Object)this);
    }

    public int lastIndexOf(int ch) {
        ScriptHelper.put((String)"str", (Object)String.valueOf((char)ch), (Object)this);
        return ScriptHelper.evalInt((String)"this.lastIndexOf(str)", (Object)this);
    }

    public int lastIndexOf(int ch, int position) {
        ScriptHelper.put((String)"str", (Object)String.valueOf((char)ch), (Object)this);
        ScriptHelper.put((String)"position", (double)position, (Object)this);
        return ScriptHelper.evalInt((String)"this.lastIndexOf(str, position)", (Object)this);
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int position) {
        ScriptHelper.put((String)"str", (Object)str, (Object)this);
        ScriptHelper.put((String)"position", (double)position, (Object)this);
        return ScriptHelper.evalInt((String)"this.indexOf(str, position)", (Object)this);
    }

    public int indexOf(int ch) {
        ScriptHelper.put((String)"ch", (double)ch, (Object)this);
        return ScriptHelper.evalInt((String)"this.indexOf(String.fromCharCode(ch), 0)", (Object)this);
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    public String substring(int beginIndex, int endIndex) {
        ScriptHelper.put((String)"beginIndex", (double)beginIndex, (Object)this);
        ScriptHelper.put((String)"endIndex", (double)endIndex, (Object)this);
        return (String)ScriptHelper.eval((String)"this.substring(beginIndex, endIndex)", (Object)this);
    }

    public String concat(String str) {
        ScriptHelper.put((String)"str", (Object)str, (Object)this);
        return (String)ScriptHelper.eval((String)"this + str", (Object)this);
    }

    public String replace(char oldChar, char newChar) {
        ScriptHelper.put((String)"oldChar", (Object)String.valueOf(oldChar), (Object)this);
        ScriptHelper.put((String)"newChar", (Object)String.valueOf(newChar), (Object)this);
        return (String)ScriptHelper.eval((String)"this.replace(new RegExp(oldChar, 'g'), newChar)", (Object)this);
    }

    public String toLowerCase() {
        return (String)ScriptHelper.eval((String)"this.toLowerCase()", (Object)this);
    }

    public String toUpperCase() {
        return (String)ScriptHelper.eval((String)"this.toUpperCase()", (Object)this);
    }

    public String trim() {
        return (String)ScriptHelper.eval((String)"this.replace(/^\\s+/, '').replace(/\\s+$/, '')", (Object)this);
    }

    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] data = new char[this.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.charAt(i);
        }
        return data;
    }

    public static String valueOf(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    public static String valueOf(char[] data) {
        return String.valueOf(data, 0, data.length);
    }

    public static String valueOf(char[] data, int offset, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(data[offset + i]);
        }
        return sb.toString();
    }

    public static String valueOf(boolean b) {
        return Boolean.toString(b);
    }

    public static String valueOf(char c) {
        ScriptHelper.put((String)"c", (double)c, null);
        return (String)ScriptHelper.eval((String)"String.fromCharCode(c)", null);
    }

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(long l) {
        ScriptHelper.put((String)"l", (double)l, null);
        return (String)ScriptHelper.eval((String)"String(l)", null);
    }

    public static String valueOf(float f) {
        ScriptHelper.put((String)"f", (double)f, null);
        return (String)ScriptHelper.eval((String)"String(f)", null);
    }

    public static String valueOf(double d) {
        ScriptHelper.put((String)"d", (double)d, null);
        return (String)ScriptHelper.eval((String)"String(d)", null);
    }

    public String[] split(String regex) {
        ScriptHelper.put((String)"regex", (Object)regex, (Object)this);
        return (String[])ScriptHelper.eval((String)"this.split(new RegExp(regex))", (Object)this);
    }

    public boolean matches(String regex) {
        ScriptHelper.put((String)"regex", (Object)("^" + regex + "$"), (Object)this);
        return ScriptHelper.evalBoolean((String)"this.match(new RegExp(regex))!=null", (Object)this);
    }

    private String replace(String regex, String flags, String replacement) {
        ScriptHelper.put((String)"regex", (Object)regex, (Object)this);
        ScriptHelper.put((String)"flags", (Object)flags, (Object)this);
        ScriptHelper.put((String)"replacement", (Object)replacement, (Object)this);
        return (String)ScriptHelper.eval((String)"this.replace(new RegExp(regex, flags), dragomeJs.unquote(replacement) )", (Object)this);
    }

    public String replaceFirst(String regex, String replacement) {
        return this.replace(regex, "", replacement);
    }

    public String replaceAll(String regex, String replacement) {
        return this.replace(regex, "g", replacement);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) != -1;
    }

    public int lastIndexOf(String str) {
        ScriptHelper.put((String)"str", (Object)str, (Object)this);
        return ScriptHelper.evalInt((String)"this.lastIndexOf(str)", (Object)this);
    }

    public String replace(CharSequence target, CharSequence replacement) {
        ScriptHelper.put((String)"string", (Object)target, (Object)this);
        ScriptHelper.put((String)"string2", (Object)replacement, (Object)this);
        return (String)ScriptHelper.eval((String)"this.replaceAll(string, string2)", (Object)this);
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }
}

