/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.dragome.commons.javascript.ScriptHelper;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class Throwable {
    protected String message;
    protected Throwable cause;
    protected String stackTrace;

    public Throwable() {
    }

    public Throwable(String newMessage) {
        this.message = newMessage;
    }

    public Throwable(Throwable cause) {
        this.cause = cause;
        ScriptHelper.put((String)"cause", (Object)cause, (Object)this);
        ScriptHelper.eval((String)"this.stack= cause.stack", (Object)this);
        this.message = cause.getMessage();
    }

    public Throwable(String message, Throwable cause) {
        this(cause);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String s = this.getClass().getName();
        if (this.message != null) {
            s = s + ": " + this.message;
        }
        return s;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream stream) {
        this.printStackTrace(new PrintWriter(new OutputStreamWriter(stream)));
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print(this.toString());
        printWriter.println(this.stackTrace);
        if (this.cause != null) {
            printWriter.println("Caused by:");
            this.cause.printInnerStackTrace(printWriter);
        } else {
            this.printInnerStackTrace(printWriter);
        }
    }

    public void printInnerStackTrace(PrintWriter printWriter) {
        if (ScriptHelper.evalBoolean((String)"this.stack", (Object)this)) {
            String stack = (String)ScriptHelper.eval((String)"this.stack", (Object)this);
            printWriter.print(stack);
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Throwable fillInStackTrace() {
        this.stackTrace = (String)ScriptHelper.eval((String)"stackTrace.toString()", (Object)this);
        return this;
    }

    public StackTraceElement[] getStackTrace() {
        return null;
    }

    public void setStackTrace(StackTraceElement[] stackTrace2) {
    }
}

