/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.dragome.commons.compiler.annotations.CompilerType;
import com.dragome.commons.compiler.annotations.DragomeCompilerSettings;
import com.dragome.commons.javascript.ScriptHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@DragomeCompilerSettings(value=CompilerType.Standard)
public final class Method {
    protected String signature;
    protected Class<?> cls;
    protected boolean accessible;
    protected Class<?>[] parametersTypes;
    protected Class<?> returnType;
    private int modifiers;

    public Method(Class<?> newCls, String theSignature, int modifiers) {
        this.signature = theSignature;
        this.cls = newCls;
        this.modifiers = modifiers;
    }

    public String getName() {
        String name = this.signature.substring(1, this.signature.lastIndexOf("$"));
        int parametersStart = name.indexOf("___");
        if (parametersStart != -1) {
            return name.substring(0, parametersStart);
        }
        return name;
    }

    public Class<?>[] getParameterTypes() {
        String signatureWithNoReturnType = this.signature.substring(0, this.signature.lastIndexOf("$"));
        String[] parameters = signatureWithNoReturnType.replaceAll("____", "__").replaceAll("___", "__").split("__");
        ArrayList<Class<Object>> result = new ArrayList<Class<Object>>();
        if (parameters.length > 1) {
            for (int i = 1; i < parameters.length; ++i) {
                String typeName = parameters[i];
                if (typeName.trim().length() <= 0 || typeName.contains("$")) continue;
                Class parameterType = Object.class;
                try {
                    parameterType = Class.forName(this.fixArrayClassName(typeName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result.add(parameterType);
            }
            return result.toArray((T[])new Class[0]);
        }
        return new Class[0];
    }

    public static String boxTypes(String typeName) {
        if ("boolean".equals(typeName)) {
            return "java.lang.Boolean";
        }
        if ("int".equals(typeName)) {
            return "java.lang.Integer";
        }
        if ("long".equals(typeName)) {
            return "java.lang.Long";
        }
        if ("short".equals(typeName)) {
            return "java.lang.Short";
        }
        if ("float".equals(typeName)) {
            return "java.lang.Float";
        }
        if ("double".equals(typeName)) {
            return "java.lang.Double";
        }
        if ("byte".equals(typeName)) {
            return "java.lang.Byte";
        }
        if ("char".equals(typeName)) {
            return "java.lang.Character";
        }
        return typeName;
    }

    public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.boxArguments(args);
        Object result = null;
        if (obj == null) {
            ScriptHelper.put((String)"relatedClass", this.cls, (Object)this);
            obj = ScriptHelper.eval((String)"relatedClass.$$$nativeClass", (Object)this);
        }
        ScriptHelper.put((String)"obj", (Object)obj, (Object)this);
        ScriptHelper.put((String)"args", (Object)args, (Object)this);
        ScriptHelper.put((String)"sig", (Object)this.signature, (Object)this);
        Object instanceMethod = ScriptHelper.eval((String)"obj[sig]", (Object)this);
        result = instanceMethod == null ? ScriptHelper.eval((String)"obj.clazz.constructor[sig](args)", (Object)this) : ScriptHelper.eval((String)"obj[sig].apply(obj, args)", (Object)this);
        result = this.adaptResult(result);
        return result;
    }

    private void boxArguments(Object ... args) {
        ScriptHelper.put((String)"args", (Object)args, (Object)this);
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ScriptHelper.put((String)"parameterType", parameterTypes[i], (Object)this);
            if (args[i] == null) continue;
            if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'boolean'", (Object)this) && args[i] instanceof Boolean) {
                ScriptHelper.put((String)"argValue", (boolean)Boolean.parseBoolean(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'int'", (Object)this) && args[i] instanceof Integer) {
                ScriptHelper.put((String)"argValue", (double)Integer.parseInt(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'long'", (Object)this) && args[i] instanceof Long) {
                ScriptHelper.put((String)"argValue", (double)Long.parseLong(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'short'", (Object)this) && args[i] instanceof Short) {
                ScriptHelper.put((String)"argValue", (double)Short.parseShort(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'float'", (Object)this) && args[i] instanceof Float) {
                ScriptHelper.put((String)"argValue", (double)Float.parseFloat(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'double'", (Object)this) && args[i] instanceof Double) {
                ScriptHelper.put((String)"argValue", (double)Double.parseDouble(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'byte'", (Object)this) && args[i] instanceof Byte) {
                ScriptHelper.put((String)"argValue", (double)Byte.parseByte(args[i].toString()), (Object)this);
            } else if (ScriptHelper.evalBoolean((String)"parameterType.realName == 'char'", (Object)this) && args[i] instanceof Character) {
                ScriptHelper.put((String)"argValue", (double)((Character)args[i]).charValue(), (Object)this);
            } else {
                ScriptHelper.put((String)"argValue", (Object)args[i], (Object)this);
            }
            ScriptHelper.put((String)"i", (double)i, (Object)this);
            ScriptHelper.eval((String)"args[i]= argValue", (Object)this);
        }
    }

    private Object adaptResult(Object result) {
        ScriptHelper.put((String)"result", (Object)result, (Object)this);
        try {
            Class<?> currentReturnType = this.getReturnType();
            if (currentReturnType.equals(Boolean.class)) {
                result = result instanceof Boolean ? result : (ScriptHelper.evalBoolean((String)"result", (Object)this) ? Boolean.TRUE : Boolean.FALSE);
            } else if (currentReturnType.equals(Integer.class)) {
                result = Integer.parseInt(ScriptHelper.evalInt((String)"result", (Object)this) + "");
            } else if (currentReturnType.equals(Long.class)) {
                result = Long.parseLong(ScriptHelper.evalInt((String)"result", (Object)this) + "");
            } else if (currentReturnType.equals(Short.class)) {
                result = Short.parseShort(ScriptHelper.evalInt((String)"result", (Object)this) + "");
            } else if (currentReturnType.equals(Float.class)) {
                result = Float.valueOf(Float.parseFloat(ScriptHelper.evalFloat((String)"result", (Object)this) + ""));
            } else if (currentReturnType.equals(Double.class)) {
                result = Double.parseDouble(ScriptHelper.evalDouble((String)"result", (Object)this) + "");
            } else if (currentReturnType.equals(Byte.class)) {
                result = (byte)ScriptHelper.evalChar((String)"result", (Object)this);
            } else if (currentReturnType.equals(Character.class)) {
                result = Character.valueOf((ScriptHelper.eval((String)"result", (Object)this) + "").charAt(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return false;
    }

    public String toString() {
        return this.signature;
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public <T> T getAnnotation(Class<T> class1) {
        return null;
    }

    public Class<?> getReturnType() {
        if (this.returnType == null) {
            try {
                String returnTypeString = this.signature.substring(this.signature.lastIndexOf("$") + 1);
                returnTypeString = this.fixArrayClassName(returnTypeString);
                this.returnType = Class.forName(returnTypeString);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.returnType;
    }

    private String fixArrayClassName(String methodName) {
        if (methodName.endsWith("[]")) {
            methodName = "[L" + methodName.substring(0, methodName.length() - 2) + ";";
        }
        return methodName;
    }

    public Type[] getGenericParameterTypes() {
        return this.getParameterTypes();
    }

    public Class<?> getDeclaringClass() {
        return this.cls;
    }

    public Type getGenericReturnType() {
        Class<?> declaringClass = this.getDeclaringClass();
        ScriptHelper.put((String)"declaringClass", declaringClass, (Object)this);
        if (ScriptHelper.evalBoolean((String)"declaringClass.$$$nativeClass.$$$$signatures ", (Object)this)) {
            String genericSignature = (String)ScriptHelper.eval((String)"declaringClass.$$$nativeClass.$$$$signatures[this.$$$signature]", (Object)this);
            genericSignature = genericSignature.replaceAll(".*<L", "");
            genericSignature = genericSignature.replaceAll(";>;", "");
            genericSignature = genericSignature.replaceAll("/", "_");
            return new ParameterizedTypeImpl(genericSignature);
        }
        return this.getReturnType();
    }

    public Object[] boxParameters(Object[] args) {
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!parameterTypes[i].isPrimitive()) continue;
            ScriptHelper.put((String)"primitiveValue", (Object)args[i], null);
            String stringValue = (String)ScriptHelper.eval((String)"primitiveValue.toString()", (Object)this);
            if (parameterTypes[i].equals(Integer.TYPE)) {
                args[i] = new Integer(stringValue);
                continue;
            }
            if (parameterTypes[i].equals(Long.TYPE)) {
                args[i] = new Long(stringValue);
                continue;
            }
            if (parameterTypes[i].equals(Float.TYPE)) {
                args[i] = new Float(stringValue);
                continue;
            }
            if (parameterTypes[i].equals(Double.TYPE)) {
                args[i] = new Double(stringValue);
                continue;
            }
            if (parameterTypes[i].equals(Short.TYPE)) {
                args[i] = new Short(stringValue);
                continue;
            }
            if (parameterTypes[i].equals(Character.TYPE)) {
                args[i] = new Character(stringValue.charAt(0));
                continue;
            }
            if (parameterTypes[i].equals(Byte.TYPE)) {
                args[i] = new Byte(stringValue);
                continue;
            }
            if (!parameterTypes[i].equals(Boolean.TYPE)) continue;
            args[i] = new Boolean(stringValue);
        }
        return args;
    }
}

