/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) != 0;
    }

    public static boolean isInterface(int modifiers) {
        return (modifiers & 0x200) != 0;
    }

    public static boolean isNative(int modifiers) {
        return (modifiers & 0x100) != 0;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isProtected(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static boolean isPublic(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static boolean isStatic(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isStrict(int modifiers) {
        return (modifiers & 0x800) != 0;
    }

    public static boolean isSynchronized(int modifiers) {
        return (modifiers & 0x20) != 0;
    }

    public static boolean isTransient(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    public static boolean isVolatile(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    public static String toString(int modifiers) {
        String[] sb = new String[]{};
        if (Modifier.isPublic(modifiers)) {
            sb[sb.length] = "public";
        }
        if (Modifier.isProtected(modifiers)) {
            sb[sb.length] = "protected";
        }
        if (Modifier.isPrivate(modifiers)) {
            sb[sb.length] = "private";
        }
        if (Modifier.isAbstract(modifiers)) {
            sb[sb.length] = "abstract";
        }
        if (Modifier.isStatic(modifiers)) {
            sb[sb.length] = "static";
        }
        if (Modifier.isFinal(modifiers)) {
            sb[sb.length] = "final";
        }
        if (Modifier.isTransient(modifiers)) {
            sb[sb.length] = "transient";
        }
        if (Modifier.isVolatile(modifiers)) {
            sb[sb.length] = "volatile";
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb[sb.length] = "synchronized";
        }
        if (Modifier.isNative(modifiers)) {
            sb[sb.length] = "native";
        }
        if (Modifier.isStrict(modifiers)) {
            sb[sb.length] = "strictfp";
        }
        if (Modifier.isInterface(modifiers)) {
            sb[sb.length] = "interface";
        }
        if (sb.length > 0) {
            return sb.toString();
        }
        return "";
    }
}

