/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.dragome.commons.AbstractProxyRelatedInvocationHandler;
import com.dragome.commons.javascript.ScriptHelper;
import java.lang.reflect.BoxingHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Proxy {
    private InvocationHandler handler;
    private final Class[] interfaces;

    protected Proxy(InvocationHandler theHandler, Class[] interfaces) {
        this.handler = theHandler;
        this.interfaces = interfaces;
    }

    public static Object invoke(Proxy object, String methodSignature, Object[] args) throws Throwable {
        if (methodSignature.startsWith("getClass()")) {
            return Proxy.class;
        }
        Method method = new Method(null, methodSignature, 1);
        return object.handler.invoke(object, method, args);
    }

    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, final InvocationHandler handler) throws IllegalArgumentException {
        Method[] objectClassMethods;
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class interfaze : interfaces) {
            methods.addAll((Collection<Method>)Arrays.asList(interfaze.getMethods()));
        }
        for (Method method : objectClassMethods = Object.class.getMethods()) {
            if (!method.getName().equals("equals") && !method.getName().equals("hashCode")) continue;
            methods.add(method);
        }
        AbstractProxyRelatedInvocationHandler handler2 = new AbstractProxyRelatedInvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                this.setProxy(proxy);
                ScriptHelper.put((String)"method", (Object)method, (Object)((Object)this));
                String methodName = (String)ScriptHelper.eval((String)"method.$$$signature", (Object)((Object)this));
                Class declaringClass = (Class)ScriptHelper.eval((String)"method.$$$cls", (Object)((Object)this));
                method.boxParameters(args);
                Method method2 = new Method(declaringClass, methodName, 1);
                Class<?> returnType = method.getReturnType();
                boolean isPrimitive = returnType != null && returnType.isPrimitive();
                Object result = handler.invoke(proxy, method2, args);
                if (isPrimitive) {
                    result = BoxingHelper.convertObjectToPrimitive(result);
                }
                return result;
            }
        };
        ScriptHelper.put((String)"interfaces", (Object)interfaces, null);
        ScriptHelper.put((String)"handler1", (Object)handler, null);
        ScriptHelper.put((String)"handler2", (Object)handler2, null);
        ScriptHelper.put((String)"methods", methods, null);
        Object result = ScriptHelper.eval((String)"createProxyOf(interfaces, methods, handler1, handler2)", null);
        return result;
    }

    public static boolean isProxyClass(Class class1) {
        ScriptHelper.put((String)"class1", (Object)class1, null);
        return ScriptHelper.evalBoolean((String)"class1 && class1.$$$nativeClass && class1.$$$nativeClass.classname.startsWith(\"ProxyOf_\")", null);
    }

    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        return ((Proxy)proxy).handler;
    }

    public static Object invokeStatic(InvocationHandler invocationHandler, Object proxy, Method method, Object[] args) throws Throwable {
        return invocationHandler.invoke(proxy, method, args);
    }
}

