/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;

public class URL {
    private String representation;

    public URL(String spec) {
        if (!spec.matches("[a-z]+://.*")) {
            throw new RuntimeException("Protocol part is missing: " + spec);
        }
        this.representation = spec;
    }

    public URL(URL context, String spec) {
        if (spec.matches("[a-z]+://.*")) {
            this.representation = spec;
        } else {
            String base = context.toString();
            String[] parts = base.split("://|\\?|#");
            String authorityAndPath = parts[1];
            int index = authorityAndPath.lastIndexOf(47);
            if (index != -1) {
                authorityAndPath = authorityAndPath.substring(0, index);
            }
            this.representation = parts[0] + "://" + authorityAndPath + '/' + spec;
        }
    }

    public String toString() {
        return this.representation;
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URLConnection openConnection() {
        return null;
    }

    public InputStream openStream() {
        return null;
    }
}

