/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

final class BasicPermissionCollection
implements Serializable {
    private static final long serialVersionUID = 739301742472979399L;
    private transient Map<String, Permission> perms = new HashMap<String, Permission>(11);
    private boolean all_allowed = false;
    private Class permClass;

    public BasicPermissionCollection(Class clazz) {
        this.permClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        BasicPermission bp = (BasicPermission)permission;
        if (this.permClass == null) {
            this.permClass = bp.getClass();
        } else if (bp.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            this.perms.put(bp.getCanonicalName(), permission);
        }
        if (!this.all_allowed && bp.getCanonicalName().equals("*")) {
            this.all_allowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        Permission x;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission bp = (BasicPermission)permission;
        if (bp.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        String path = bp.getCanonicalName();
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            x = this.perms.get(path);
        }
        if (x != null) {
            return x.implies(permission);
        }
        int offset = path.length() - 1;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<Permission> elements() {
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            return Collections.enumeration(this.perms.values());
        }
    }
}

