/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.dragome.commons.javascript.ScriptHelper;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayList<E>
extends AbstractCollection<E>
implements List<E> {
    private E[] array;
    private int start;
    private int end;
    private ArrayList<E> backingList;

    public ArrayList() {
        this.array = new Object[0];
        this.start = 0;
        this.end = this.array.length;
    }

    public ArrayList(Collection<? extends E> list) {
        this();
        for (E elem : list) {
            this.add(elem);
        }
    }

    protected ArrayList(ArrayList<E> theBackingList, int theStart, int theEnd) {
        this.start = theStart;
        this.end = theEnd;
        this.backingList = theBackingList;
        this.array = this.backingList.array;
    }

    public ArrayList(int initialCapacity) {
        ++initialCapacity;
    }

    @Override
    public boolean add(E element) {
        ScriptHelper.put((String)"element", element, (Object)this);
        ScriptHelper.eval((String)"this.$$$array.push(element)", (Object)this);
        ++this.end;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.end - this.start) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ScriptHelper.put((String)"index", (double)index, (Object)this);
        ScriptHelper.put((String)"element", element, (Object)this);
        ScriptHelper.eval((String)"this.$$$array.splice(index, 0, element)", (Object)this);
        ++this.end;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.end - this.start);
    }

    @Override
    public boolean contains(Object value) {
        for (int i = this.start; i < this.end; ++i) {
            E e = this.array[i];
            if (e != value && (e == null || !e.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayListIterator(this);
    }

    public void ensureCapacity(int capacity) {
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ArrayList)) {
            return false;
        }
        ArrayList other = (ArrayList)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            E e1 = this.get(i);
            E e2 = other.get(i);
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.end - this.start) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.array[this.start + index];
    }

    @Override
    public int indexOf(Object elem) {
        for (int i = this.start; i < this.end; ++i) {
            if ((elem != null || this.array[i] != null) && (elem == null || !elem.equals(this.array[i]))) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    public int lastIndexOf(Object elem) {
        for (int i = this.end; i >= this.start; --i) {
            if (elem != this.array[i]) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public boolean remove(Object elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public E remove(int index) {
        E obj = this.array[index];
        this.removeRange(index, index + 1);
        return obj;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int deleteCount = toIndex - fromIndex;
        if (fromIndex < 0 || toIndex > this.end - this.start) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int srcPosition = this.start + fromIndex + deleteCount;
        System.arraycopy(this.array, srcPosition, this.array, this.start + fromIndex, this.array.length - srcPosition);
        ScriptHelper.put((String)"newSize", (double)(this.array.length - deleteCount), (Object)this);
        ScriptHelper.eval((String)"this.$$$array.length = newSize", (Object)this);
        this.incEnd(-deleteCount);
    }

    private void incEnd(int count) {
        this.end += count;
        if (this.backingList != null) {
            super.incEnd(count);
        }
    }

    @Override
    public E set(int index, E elem) {
        if (index < 0 || index >= this.end - this.start) {
            throw new ArrayIndexOutOfBoundsException();
        }
        E old = this.array[this.start + index];
        this.array[this.start + index] = elem;
        return old;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ArrayList<E>(this, fromIndex, toIndex);
    }

    public void trimToSize() {
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ArrayListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ArrayListIterator(this, index);
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        int numMoved = this.size() - index;
        if (numMoved > 0) {
            System.arraycopy(this.array, index, this.array, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.array, index, numNew);
        this.end += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return c.size() > 0;
    }

    class ArrayListIterator
    implements ListIterator<E> {
        private int lastReturnedIndex = -1;
        private ArrayList<E> list;
        private int currentIndex;

        public ArrayListIterator(ArrayList<E> theList) {
            this.list = theList;
            this.currentIndex = 0;
        }

        public ArrayListIterator(ArrayList<E> theList, int index) {
            this.list = theList;
            this.currentIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.list.size() > this.currentIndex;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.currentIndex++;
            return this.list.get(this.lastReturnedIndex);
        }

        @Override
        public void remove() {
            if (this.lastReturnedIndex == -1) {
                throw new RuntimeException();
            }
            this.list.remove(this.lastReturnedIndex);
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex > 0;
        }

        @Override
        public E previous() {
            this.lastReturnedIndex = this.currentIndex - 1;
            return this.list.get(this.lastReturnedIndex);
        }

        @Override
        public int nextIndex() {
            return this.currentIndex + 1;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void set(E e) {
            this.list.set(this.lastReturnedIndex, e);
        }

        @Override
        public void add(E e) {
            this.list.add(e);
        }
    }
}

