/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.dragome.commons.javascript.ScriptHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Arrays {
    public static <T> List<T> asList(T ... a) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : a) {
            result.add(t);
        }
        return result;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null || a1.length != a2.length) {
            return false;
        }
        int count = a1.length;
        for (int i = 0; i < count; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    public static void sort(Object[] array) {
        ScriptHelper.put((String)"array", (Object)array, null);
        ScriptHelper.eval((String)"array.sort()", null);
    }

    public static void sort(Object[] array, int fromIndex, int toIndex) {
        ScriptHelper.put((String)"array", (Object)array, null);
        ScriptHelper.put((String)"fromIndex", (double)fromIndex, null);
        ScriptHelper.put((String)"toIndex", (double)toIndex, null);
        Object subarray = ScriptHelper.eval((String)"array.slice(fromIndex, toIndex)", null);
        ScriptHelper.put((String)"subarray", (Object)subarray, null);
        ScriptHelper.eval((String)"subarray.sort()", null);
        ScriptHelper.eval((String)"for (var i= fromIndex; i < toIndex; ++i)\tarray[i]= subarray[i - fromIndex]", null);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comparator) {
        int i;
        Object[] subarray = new Object[toIndex - fromIndex];
        for (i = fromIndex; i < toIndex; ++i) {
            subarray[i - fromIndex] = a[i];
        }
        Arrays.sort(subarray, comparator);
        for (i = fromIndex; i < toIndex; ++i) {
            a[i] = subarray[i - fromIndex];
        }
    }

    public static <T> void sort(T[] array, Comparator<? super T> comparator) {
        ScriptHelper.put((String)"array", array, null);
        if (comparator == null) {
            comparator = new NaturalOrder<T>();
        }
        ScriptHelper.put((String)"c", comparator, null);
        ScriptHelper.eval((String)"array.sort(function(o1, o2) {return c.$compare___java_lang_Object__java_lang_Object$int(o1, o2)})", null);
    }

    public static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (Object element : array) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static void sort(double[] a) {
        Arrays.sort(a);
    }

    public static boolean deepEquals0(Object a, Object b) {
        return false;
    }

    private static class NaturalOrder<T extends Comparable<Object>>
    implements Comparator<T> {
        private NaturalOrder() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1 != null ? o1.compareTo(o2) : (o2 != null ? o2.compareTo(o1) : 0);
        }
    }
}

