/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.dragome.commons.javascript.ScriptHelper;
import java.util.Date;
import java.util.TimeZone;

public class Calendar {
    public static int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static int HOUR_OF_DAY = 11;
    public static int MINUTE = 12;
    public static int MONTH = 2;
    public static int SECOND = 13;
    public static int YEAR = 1;
    public static int ZONE_OFFSET = 15;
    private Date date = new Date();
    private TimeZone timeZone;
    private String zID;

    public final Date getTime() {
        return this.date;
    }

    public final void setTime(Date theDate) {
        this.date = theDate;
    }

    public static Calendar getInstance() {
        return Calendar.getInstance(new TimeZone());
    }

    public static Calendar getInstance(TimeZone zone) {
        Calendar cal = new Calendar();
        return cal;
    }

    protected long getTimeInMillis() {
        return this.date.getTime();
    }

    protected void setTimeInMillis(long millis) {
        this.date.setTime(millis);
    }

    public final int get(int field) {
        String functionName = this.zID;
        if (field == MONTH) {
            functionName = functionName + "Month";
        } else if (field == 7) {
            functionName = functionName + "Day";
        } else if (field == DAY_OF_MONTH) {
            functionName = functionName + "Date";
        } else if (field == YEAR) {
            functionName = functionName + "FullYear";
        } else if (field == HOUR_OF_DAY) {
            functionName = functionName + "Hours";
        } else if (field == MINUTE) {
            functionName = functionName + "Minutes";
        } else if (field == SECOND) {
            functionName = functionName + "Seconds";
        } else if (field == ZONE_OFFSET) {
            functionName = "TimezoneOffset";
        } else {
            throw new IllegalArgumentException("Field number not allowed: " + field);
        }
        ScriptHelper.put((String)"functionName", (Object)("get" + functionName), (Object)this);
        int value = ScriptHelper.evalInt((String)"this.date.nativeDate[functionName]()", (Object)this);
        if (field == 7) {
            ++value;
        }
        return value;
    }

    public final void set(int field, int value) {
        String functionName;
        if (field == MONTH) {
            functionName = this.zID + "Month";
        } else if (field == YEAR) {
            functionName = this.zID + "Year";
        } else if (field == 7) {
            value = (value - 1 + 7) % 7;
            functionName = this.zID + "Day";
        } else {
            throw new IllegalArgumentException("Field number not allowed: " + field);
        }
        ScriptHelper.put((String)"value", (double)value, (Object)this);
        ScriptHelper.put((String)"functionName", (Object)("set" + functionName), (Object)this);
        ScriptHelper.eval((String)"this.date.nativeDate[functionName](value)", (Object)this);
    }

    public boolean equals(Object obj) {
        return this.date.equals(((Calendar)obj).date);
    }

    public boolean before(Object when) {
        return this.getTimeInMillis() < ((Calendar)when).getTimeInMillis();
    }

    public boolean after(Object when) {
        return this.getTimeInMillis() > ((Calendar)when).getTimeInMillis();
    }

    public void setTimeZone(TimeZone zone) {
        this.timeZone = zone;
        this.zID = "";
        if (this.timeZone.getID().equals("GMT")) {
            this.zID = "UTC";
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

