/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class Collections {
    public static final Set EMPTY_SET = new EmptySet();
    private static Random r = new Random();

    public static <E> List<E> checkedList(List<E> list, Class<E> type) {
        return list;
    }

    public static Enumeration enumeration(Collection c) {
        return new IteratorEnumarator(c.iterator());
    }

    public static void shuffle(List<?> list) {
        int size;
        for (int i = size = list.size(); i > 1; --i) {
            Collections.swap(list, i - 1, r.nextInt(i));
        }
    }

    public static void sort(List<String> list) {
        Object[] array = (String[])list.toArray();
        Arrays.sort(array);
        int count = array.length;
        list.clear();
        for (int i = 0; i < count; ++i) {
            list.add((String)array[i]);
        }
    }

    public static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return map;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return new HashMap();
    }

    public static final <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list;
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        return collection;
    }

    public static void reverse(List<?> list) {
        int size = list.size();
        ListIterator<?> fwd = list.listIterator();
        ListIterator<?> rev = list.listIterator(size);
        int mid = list.size() >> 1;
        for (int i = 0; i < mid; ++i) {
            Object tmp = fwd.next();
            fwd.set(rev.previous());
            rev.set(tmp);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        Object[] a = list.toArray();
        Arrays.sort(a, c);
        ListIterator<T> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return list;
    }

    private static class IteratorEnumarator<E>
    implements Enumeration<E> {
        Iterator<E> iterator;

        IteratorEnumarator(Iterator<E> theIterator) {
            this.iterator = theIterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }
    }

    private static final class EmptySet
    extends HashSet {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

