/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntryImpl;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Utility;

public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private transient boolean accessOrder;
    private final transient ChainEntry head = new ChainEntry();
    private final transient HashMap<K, ChainEntry> map = new HashMap();

    public LinkedHashMap() {
        this.head.prev = this.head;
        this.head.next = this.head;
    }

    public LinkedHashMap(int ignored) {
        super(ignored);
        this.head.prev = this.head;
        this.head.next = this.head;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> toBeCopied) {
        this.head.prev = this.head;
        this.head.next = this.head;
        this.putAll(toBeCopied);
    }

    @Override
    @Override
    public void clear() {
        this.map.clear();
        this.head.prev = this.head;
        this.head.next = this.head;
    }

    @Override
    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    @Override
    public boolean containsValue(Object value) {
        ChainEntry node = this.head.next;
        while (node != this.head) {
            if (Utility.equalsWithNullCheck(node.getValue(), value)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    @Override
    public V get(Object key) {
        ChainEntry entry = this.map.get(key);
        if (entry != null) {
            this.recordAccess(entry);
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Override
    public V put(K key, V value) {
        ChainEntry old = this.map.get(key);
        if (old == null) {
            ChainEntry newEntry = new ChainEntry(key, value);
            this.map.put(key, newEntry);
            newEntry.addToEnd();
            ChainEntry eldest = this.head.next;
            if (this.removeEldestEntry(eldest)) {
                eldest.remove();
                this.map.remove(eldest.getKey());
            }
            return null;
        }
        Object oldValue = old.getValue();
        old.setValue(value);
        this.recordAccess(old);
        return oldValue;
    }

    @Override
    @Override
    public V remove(Object key) {
        ChainEntry entry = this.map.remove(key);
        if (entry != null) {
            entry.remove();
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Override
    public int size() {
        return this.map.size();
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    private void recordAccess(ChainEntry entry) {
        if (this.accessOrder) {
            entry.remove();
            entry.addToEnd();
        }
    }

    private final class EntrySet
    extends HashSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (LinkedHashMap.this.containsKey(key)) {
                Object value = LinkedHashMap.this.get(key);
                return Utility.equalsWithNullCheck(entry.getValue(), value);
            }
            return false;
        }

        @Override
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        @Override
        public int size() {
            return LinkedHashMap.this.map.size();
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private ChainEntry last;
            private ChainEntry next;

            public EntryIterator() {
                this.next = LinkedHashMap.this.head.next;
            }

            @Override
            public boolean hasNext() {
                return this.next != LinkedHashMap.this.head;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.next == LinkedHashMap.this.head) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = this.next.next;
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException("No current entry");
                }
                this.last.remove();
                LinkedHashMap.this.map.remove(this.last.getKey());
                this.last = null;
            }
        }
    }

    private class ChainEntry
    extends MapEntryImpl<K, V> {
        private transient ChainEntry next;
        private transient ChainEntry prev;

        public ChainEntry() {
            this(null, null);
        }

        public ChainEntry(K key, V value) {
            super(key, value);
            this.prev = null;
            this.next = null;
        }

        public void addToEnd() {
            ChainEntry tail = ((LinkedHashMap)LinkedHashMap.this).head.prev;
            assert (LinkedHashMap.this.head != null && tail != null);
            assert (this.next == null && this.prev == null);
            this.prev = tail;
            this.next = LinkedHashMap.this.head;
            tail.next = ((LinkedHashMap)LinkedHashMap.this).head.prev = this;
        }

        public void remove() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
        }
    }
}

