/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class LinkedList<E>
extends ArrayList<E>
implements List<E>,
Queue<E>,
Serializable {
    private E exposeElement;
    private Node<E> header;
    private int size;

    public LinkedList() {
        this.clear();
    }

    public LinkedList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    @Override
    public boolean add(E o) {
        this.addLast(o);
        return true;
    }

    public void addFirst(E o) {
        new Node<E>(o, this.header.next);
        ++this.size;
    }

    public void addLast(E o) {
        new Node<E>(o, this.header);
        ++this.size;
    }

    @Override
    @Override
    public void clear() {
        this.header = new Node();
        this.size = 0;
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    public E getFirst() {
        this.throwEmptyException();
        return this.header.next.value;
    }

    public E getLast() {
        this.throwEmptyException();
        return this.header.prev.value;
    }

    @Override
    @Override
    public ListIterator<E> listIterator(int index) {
        Node<E> node;
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(index);
        }
        if (index >= this.size >> 1) {
            node = this.header;
            for (int i = this.size; i > index; --i) {
                node = node.prev;
            }
        } else {
            node = this.header.next;
            for (int i = 0; i < index; ++i) {
                node = node.next;
            }
        }
        return new ListIteratorImpl(index, node);
    }

    @Override
    public boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    public E removeFirst() {
        this.throwEmptyException();
        --this.size;
        Node node = this.header.next;
        node.remove();
        return node.value;
    }

    public E removeLast() {
        this.throwEmptyException();
        --this.size;
        Node node = this.header.prev;
        node.remove();
        return node.value;
    }

    @Override
    @Override
    public int size() {
        return this.size;
    }

    private void addBefore(E o, Node<E> target) {
        new Node<E>(o, target);
        ++this.size;
    }

    private void throwEmptyException() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean contains(Object value) {
        ListIterator<E> iterator = this.listIterator(0);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != value && (e == null || !e.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static class Node<E> {
        public Node<E> next;
        public Node<E> prev;
        public E value;

        public Node() {
            this.next = this.prev = this;
        }

        public Node(E value) {
            this.value = value;
        }

        public Node(E value, Node<E> nextNode) {
            this(value);
            this.next = nextNode;
            this.prev = nextNode.prev;
            nextNode.prev.next = this;
            nextNode.prev = this;
        }

        public void remove() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.next = this.prev = this;
        }
    }

    private final class ListIteratorImpl
    implements ListIterator<E> {
        protected int currentIndex;
        protected Node<E> currentNode;
        protected Node<E> lastNode = null;

        public ListIteratorImpl(int index, Node<E> startNode) {
            this.currentNode = startNode;
            this.currentIndex = index;
        }

        @Override
        public void add(E o) {
            LinkedList.this.addBefore(o, this.currentNode);
            ++this.currentIndex;
            this.lastNode = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != LinkedList.this.header;
        }

        @Override
        public boolean hasPrevious() {
            return this.currentNode.prev != LinkedList.this.header;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.currentNode;
            this.currentNode = this.currentNode.next;
            ++this.currentIndex;
            return this.lastNode.value;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.currentNode = this.currentNode.prev;
            this.lastNode = this.currentNode;
            --this.currentIndex;
            return this.lastNode.value;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void remove() {
            this.verifyCurrentElement();
            if (this.currentNode == this.lastNode) {
                this.currentNode = this.lastNode.next;
            } else {
                --this.currentIndex;
            }
            this.lastNode.remove();
            this.lastNode = null;
            --LinkedList.this.size;
        }

        @Override
        public void set(E o) {
            this.verifyCurrentElement();
            this.lastNode.value = o;
        }

        protected void verifyCurrentElement() {
            if (this.lastNode == null) {
                throw new IllegalStateException();
            }
        }
    }
}

