/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public final class Spliterators {
    private static final Spliterator<Object> EMPTY_SPLITERATOR = new EmptySpliterator.OfRef<Object>();
    private static final Spliterator.OfInt EMPTY_INT_SPLITERATOR = new EmptySpliterator.OfInt();
    private static final Spliterator.OfLong EMPTY_LONG_SPLITERATOR = new EmptySpliterator.OfLong();
    private static final Spliterator.OfDouble EMPTY_DOUBLE_SPLITERATOR = new EmptySpliterator.OfDouble();

    private Spliterators() {
    }

    public static <T> Spliterator<T> emptySpliterator() {
        return EMPTY_SPLITERATOR;
    }

    public static Spliterator.OfInt emptyIntSpliterator() {
        return EMPTY_INT_SPLITERATOR;
    }

    public static Spliterator.OfLong emptyLongSpliterator() {
        return EMPTY_LONG_SPLITERATOR;
    }

    public static Spliterator.OfDouble emptyDoubleSpliterator() {
        return EMPTY_DOUBLE_SPLITERATOR;
    }

    public static <T> Spliterator<T> spliterator(Object[] array, int additionalCharacteristics) {
        return new ArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static <T> Spliterator<T> spliterator(Object[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new ArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    public static Spliterator.OfInt spliterator(int[] array, int additionalCharacteristics) {
        return new IntArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static Spliterator.OfInt spliterator(int[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new IntArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    public static Spliterator.OfLong spliterator(long[] array, int additionalCharacteristics) {
        return new LongArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static Spliterator.OfLong spliterator(long[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new LongArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int additionalCharacteristics) {
        return new DoubleArraySpliterator(Objects.requireNonNull(array), additionalCharacteristics);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(array).length, fromIndex, toIndex);
        return new DoubleArraySpliterator(array, fromIndex, toIndex, additionalCharacteristics);
    }

    private static void checkFromToBounds(int arrayLength, int origin, int fence) {
        if (origin > fence) {
            throw new IllegalArgumentException("origin(" + origin + ") > fence(" + fence + ")");
        }
        if (origin < 0) {
            throw new ArrayIndexOutOfBoundsException(origin);
        }
        if (fence > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(fence);
        }
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> c, int characteristics) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(c), characteristics);
    }

    public static <T> Spliterator<T> spliterator(Iterator<? extends T> iterator, long size, int characteristics) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), size, characteristics);
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<? extends T> iterator, int characteristics) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), characteristics);
    }

    public static <T> Iterator<T> iterator(Spliterator<? extends T> spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements Iterator<T>,
        Consumer<T> {
            boolean valueReady = false;
            T nextElement;
            final /* synthetic */ Spliterator val$spliterator;

            Adapter(Spliterator spliterator) {
                this.val$spliterator = spliterator;
            }

            @Override
            @Override
            public void accept(T t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            @Override
            public T next() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(spliterator);
    }

    static class IteratorSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final Collection<? extends T> collection;
        private Iterator<? extends T> it;
        private final int characteristics;
        private long est;
        private int batch;

        public IteratorSpliterator(Collection<? extends T> collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        @Override
        public Spliterator<T> trySplit() {
            long s;
            Iterator<Object> i = this.it;
            if (i == null) {
                this.it = this.collection.iterator();
                i = this.it;
                s = this.est = (long)this.collection.size();
            } else {
                s = this.est;
            }
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySpliterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Iterator<T> i = this.it;
            if (i == null) {
                this.it = this.collection.iterator();
                i = this.it;
                this.est = this.collection.size();
            }
            i.forEachRemaining(action);
        }

        @Override
        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            if (this.it.hasNext()) {
                action.accept(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        @Override
        public long estimateSize() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
                return this.est;
            }
            return this.est;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class AbstractDoubleSpliterator
    implements Spliterator.OfDouble {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractDoubleSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        @Override
        public Spliterator.OfDouble trySplit() {
            HoldingDoubleConsumer holder = new HoldingDoubleConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                double[] a = new double[n];
                int j = 0;
                do {
                    a[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new DoubleArraySpliterator(a, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingDoubleConsumer
        implements DoubleConsumer {
            double value;

            HoldingDoubleConsumer() {
            }

            @Override
            @Override
            public void accept(double value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractLongSpliterator
    implements Spliterator.OfLong {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractLongSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        @Override
        public Spliterator.OfLong trySplit() {
            HoldingLongConsumer holder = new HoldingLongConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                long[] a = new long[n];
                int j = 0;
                do {
                    a[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new LongArraySpliterator(a, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingLongConsumer
        implements LongConsumer {
            long value;

            HoldingLongConsumer() {
            }

            @Override
            @Override
            public void accept(long value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractIntSpliterator
    implements Spliterator.OfInt {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractIntSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        @Override
        public Spliterator.OfInt trySplit() {
            HoldingIntConsumer holder = new HoldingIntConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                int[] a = new int[n];
                int j = 0;
                do {
                    a[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new IntArraySpliterator(a, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingIntConsumer
        implements IntConsumer {
            int value;

            HoldingIntConsumer() {
            }

            @Override
            @Override
            public void accept(int value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractSpliterator(long est, int additionalCharacteristics) {
            this.est = est;
            this.characteristics = (additionalCharacteristics & 0x40) != 0 ? additionalCharacteristics | 0x4000 : additionalCharacteristics;
        }

        @Override
        @Override
        public Spliterator<T> trySplit() {
            HoldingConsumer holder = new HoldingConsumer();
            long s = this.est;
            if (s > 1L && this.tryAdvance(holder)) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j] = holder.value;
                } while (++j < n && this.tryAdvance(holder));
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySpliterator(a, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingConsumer<T>
        implements Consumer<T> {
            Object value;

            HoldingConsumer() {
            }

            @Override
            @Override
            public void accept(T value) {
                this.value = value;
            }
        }
    }

    static final class DoubleArraySpliterator
    implements Spliterator.OfDouble {
        private final double[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public DoubleArraySpliterator(double[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public DoubleArraySpliterator(double[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        @Override
        public Spliterator.OfDouble trySplit() {
            DoubleArraySpliterator doubleArraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                doubleArraySpliterator = null;
            } else {
                this.index = mid;
                DoubleArraySpliterator doubleArraySpliterator2 = new DoubleArraySpliterator(this.array, lo, this.index, this.characteristics);
                doubleArraySpliterator = doubleArraySpliterator2;
            }
            return doubleArraySpliterator;
        }

        @Override
        @Override
        public void forEachRemaining(DoubleConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            double[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongArraySpliterator
    implements Spliterator.OfLong {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public LongArraySpliterator(long[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public LongArraySpliterator(long[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        @Override
        public Spliterator.OfLong trySplit() {
            LongArraySpliterator longArraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                longArraySpliterator = null;
            } else {
                this.index = mid;
                LongArraySpliterator longArraySpliterator2 = new LongArraySpliterator(this.array, lo, this.index, this.characteristics);
                longArraySpliterator = longArraySpliterator2;
            }
            return longArraySpliterator;
        }

        @Override
        @Override
        public void forEachRemaining(LongConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntArraySpliterator
    implements Spliterator.OfInt {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public IntArraySpliterator(int[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public IntArraySpliterator(int[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        @Override
        public Spliterator.OfInt trySplit() {
            IntArraySpliterator intArraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                intArraySpliterator = null;
            } else {
                this.index = mid;
                IntArraySpliterator intArraySpliterator2 = new IntArraySpliterator(this.array, lo, this.index, this.characteristics);
                intArraySpliterator = intArraySpliterator2;
            }
            return intArraySpliterator;
        }

        @Override
        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class ArraySpliterator<T>
    implements Spliterator<T> {
        private final Object[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySpliterator(Object[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public ArraySpliterator(Object[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        @Override
        public Spliterator<T> trySplit() {
            ArraySpliterator<T> arraySpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                arraySpliterator = null;
            } else {
                this.index = mid;
                ArraySpliterator<T> arraySpliterator2 = new ArraySpliterator<T>(this.array, lo, this.index, this.characteristics);
                arraySpliterator = arraySpliterator2;
            }
            return arraySpliterator;
        }

        @Override
        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                Object e = this.array[this.index++];
                action.accept(e);
                return true;
            }
            return false;
        }

        @Override
        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    private static abstract class EmptySpliterator<T, S extends Spliterator<T>, C> {
        EmptySpliterator() {
        }

        public S trySplit() {
            return null;
        }

        public boolean tryAdvance(C consumer) {
            Objects.requireNonNull(consumer);
            return false;
        }

        public void forEachRemaining(C consumer) {
            Objects.requireNonNull(consumer);
        }

        public long estimateSize() {
            return 0L;
        }

        public int characteristics() {
            return 16448;
        }

        private static final class OfDouble
        extends EmptySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble() {
            }
        }

        private static final class OfLong
        extends EmptySpliterator<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong() {
            }
        }

        private static final class OfInt
        extends EmptySpliterator<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt() {
            }
        }

        private static final class OfRef<T>
        extends EmptySpliterator<T, Spliterator<T>, Consumer<? super T>>
        implements Spliterator<T> {
            OfRef() {
            }
        }
    }
}

