/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

public class Level {
    private static Level[] levels = new Level[4];
    private static int count = 0;
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    public static final Level FINER = new Level("FINER", 500);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level FINEST = new Level("FINEST", 300);
    private int value;
    private String name;

    public static Level parse(String name) throws IllegalArgumentException {
        for (Level level : levels) {
            if (!level.matches(name)) continue;
            return level;
        }
        throw new IllegalArgumentException("Invalid level: " + name);
    }

    protected Level(String name, int value) {
        this.name = name;
        this.value = value;
        Level.levels[Level.count++] = this;
    }

    private boolean matches(String pattern) {
        return pattern.equals(this.name) || pattern.equals(String.valueOf(this.value));
    }

    public String getName() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }
}

