/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.stream.Streams;

public interface IntStream
extends BaseStream<Integer, IntStream> {
    public IntStream filter(IntPredicate var1);

    public IntStream map(IntUnaryOperator var1);

    public <U> Stream<U> mapToObj(IntFunction<? extends U> var1);

    public LongStream mapToLong(IntToLongFunction var1);

    public DoubleStream mapToDouble(IntToDoubleFunction var1);

    public IntStream flatMap(IntFunction<? extends IntStream> var1);

    public IntStream distinct();

    public IntStream sorted();

    public IntStream peek(IntConsumer var1);

    public IntStream limit(long var1);

    public IntStream skip(long var1);

    public void forEach(IntConsumer var1);

    public void forEachOrdered(IntConsumer var1);

    public int[] toArray();

    public int reduce(int var1, IntBinaryOperator var2);

    public OptionalInt reduce(IntBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjIntConsumer<R> var2, BiConsumer<R, R> var3);

    public int sum();

    public OptionalInt min();

    public OptionalInt max();

    public long count();

    public OptionalDouble average();

    public IntSummaryStatistics summaryStatistics();

    public boolean anyMatch(IntPredicate var1);

    public boolean allMatch(IntPredicate var1);

    public boolean noneMatch(IntPredicate var1);

    public OptionalInt findFirst();

    public OptionalInt findAny();

    public LongStream asLongStream();

    public DoubleStream asDoubleStream();

    public Stream<Integer> boxed();

    @Override
    @Override
    public IntStream sequential();

    @Override
    @Override
    public IntStream parallel();

    @Override
    public PrimitiveIterator.OfInt iterator();

    @Override
    public Spliterator.OfInt spliterator();

    public static IntStream empty() {
        return StreamSupport.intStream(Spliterators.emptyIntSpliterator(), false);
    }

    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStream.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(startInclusive, endExclusive, false), false);
    }

    public static interface Builder
    extends IntConsumer {
        @Override
        @Override
        public void accept(int var1);

        default public Builder add(int t) {
            this.accept(t);
            return this;
        }

        public IntStream build();
    }
}

