/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.CarrierVO;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.GetCarrierListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetCustomerListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportOneVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterCarrierService;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterCustomerService;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterGoodsService;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseLogicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehousePhysicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseOrgRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportDetailApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryReportDataSourceEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailDtEo;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailProductDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportExtraDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_report_one")
public class ImportDailyDeliveryReportOneImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportDailyDeliveryReportOneImpl.class);
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Resource
    private BasedataCenterCarrierService basedataCenterCarrierService;
    @Resource
    private BasedataCenterAreaService basedataCenterAreaService;
    @Resource
    private InventoryCenterBaseWarehousePhysicalWarehouseService inventoryCenterInquiryService;
    @Resource
    private InventoryCenterBaseWarehouseLogicalWarehouseService inventoryCenterBaseWarehouseLogicalWarehouseService;
    @Resource
    private BasedataCenterCustomerService basedataCenterCustomerService;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private BasedataCenterGoodsService basedataCenterGoodsService;
    @Resource
    private IDailyDeliveryReportDetailApi deliveryReportDetailApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        Map itemMap;
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportDailyDeliveryReportOneVO.class);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        Map itemRespDtoMap = new HashMap();
        List longCodes = list.stream().map(ImportDailyDeliveryReportOneVO::getLongCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(longCodes) && ObjectUtil.isNotEmpty((Object)(itemMap = (Map)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.getItemByLongCode(longCodes))))) {
            itemRespDtoMap = itemMap;
        }
        HashMap finalItemRespDtoMap = itemRespDtoMap;
        list.forEach(i -> {
            this.checkForm((ImportDailyDeliveryReportOneVO)((Object)i), finalItemRespDtoMap);
            String key = i.getConsignmentNo() + i.getDocumentNo() + i.getTransportNo() + i.getLongCode() + i.getBatch();
            this.checkRepeatData(key, checkRepeatData, (ImportDailyDeliveryReportOneVO)((Object)i));
        });
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u6821\u9a8c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List list = (List)obj;
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        HashMap<String, ImportDailyDeliveryReportOneVO> repeatMap = new HashMap<String, ImportDailyDeliveryReportOneVO>();
        HashMap<String, Long> insMap = new HashMap<String, Long>();
        for (ImportDailyDeliveryReportOneVO v : list) {
            log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u5904\u7406\u884c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)v)));
            if (StringUtils.isNotBlank((CharSequence)v.getErrorMsg())) continue;
            DailyDeliveryReportDetailProductDto productDto = new DailyDeliveryReportDetailProductDto();
            String dataKey = String.format("%s%s%s%s%s", v.getConsignmentNo(), v.getDocumentNo(), v.getTransportNo(), v.getLongCode(), v.getBatch());
            if (repeatMap.containsKey(dataKey)) {
                v.setErrorMsg("\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165");
                continue;
            }
            String orderKey = String.format("%s%s%s", v.getConsignmentNo(), v.getDocumentNo(), v.getTransportNo());
            Long orderId = null;
            if (!insMap.containsKey(orderKey)) {
                block13: {
                    DailyDeliveryReportDto reportDto = (DailyDeliveryReportDto)this.dailyDeliveryReportApi.getByGroup(v.getDocumentNo(), v.getConsignmentNo(), v.getTransportNo()).getData();
                    if (ObjectUtil.isEmpty((Object)reportDto)) {
                        try {
                            orderId = this.createOrder(v);
                            break block13;
                        }
                        catch (Exception e) {
                            log.error("\u65b0\u589e\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u5355\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                            log.error(e.getMessage(), (Throwable)e);
                            v.setErrorMsg("\u65b0\u589e\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u5355\u636e\u5f02\u5e38\uff1a" + e.getMessage());
                            continue;
                        }
                    }
                    if (ObjectUtil.isNotEmpty((Object)reportDto) && StringUtils.isBlank((CharSequence)v.getLongCode())) {
                        v.setErrorMsg("\u5355\u636e\u5df2\u5b58\u5728");
                        continue;
                    }
                    orderId = reportDto.getId();
                }
                insMap.put(orderKey, orderId);
            } else {
                orderId = (Long)insMap.get(orderKey);
            }
            if (StringUtils.isNotBlank((CharSequence)v.getLongCode())) {
                DailyDeliveryReportDetailPageReqDto detailReqDto = new DailyDeliveryReportDetailPageReqDto();
                detailReqDto.setPageNum(Integer.valueOf(1));
                detailReqDto.setPageSize(Integer.valueOf(1));
                detailReqDto.setDailyDeliveryReportId(orderId);
                detailReqDto.setLongCode(v.getLongCode());
                detailReqDto.setBatch(v.getBatch());
                log.info("\u6821\u9a8c\u660e\u7ec6\u662f\u5426\u5df2\u5b58\u5728\u5e93\u5185\uff1a{}", (Object)JSON.toJSONString((Object)detailReqDto));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.deliveryReportDetailApi.pageList(detailReqDto));
                if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                    log.info("\u6821\u9a8c\u660e\u7ec6\u662f\u5426\u5df2\u5b58\u5728\u5e93\u5185\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
                    v.setErrorMsg("\u53d1\u8d27\u660e\u7ec6\u5df2\u5b58\u5728");
                    continue;
                }
                try {
                    this.createDetail(v, orderId);
                }
                catch (Exception e) {
                    log.error("\u65b0\u589e\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u660e\u7ec6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    v.setErrorMsg("\u65b0\u589e\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u660e\u7ec6\u5f02\u5e38\uff1a" + e.getMessage());
                    continue;
                }
            }
            repeatMap.put(dataKey, v);
        }
        String errorMsgUrl = null;
        List msgList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(msgList)) {
            log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString(msgList));
            String excelName = String.format("%s%s", "\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportDailyDeliveryReportOneVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private void checkForm(ImportDailyDeliveryReportOneVO i, Map<String, DailyDeliveryReportDetailDtEo> itemRespDtoMap) {
        boolean r;
        PageInfo list;
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)i.getLongCode())) {
            if (ObjectUtil.isEmpty((Object)itemRespDtoMap.get(i.getLongCode()))) {
                errorMsg.append("\u627e\u4e0d\u5230\u5546\u54c1\u4fe1\u606f;");
            } else {
                DailyDeliveryReportDetailDtEo itemRespDto = itemRespDtoMap.get(i.getLongCode());
                i.setProductName(itemRespDto.getProductName());
                i.setCartonQuantity(itemRespDto.getCartonQuantity());
                i.setSmallBottles(itemRespDto.getSmallBottles());
                i.setWeight(itemRespDto.getWeight());
                i.setVolume(itemRespDto.getVolume());
                i.setInternalTransaction(itemRespDto.getInternalTransaction());
                i.setRecommendPrice(itemRespDto.getRecommendPrice());
            }
        }
        List lists = (List)this.logicWarehouseQueryApi.queryOrgList().getData();
        if (null == i.getInventoryOrganizationName() || i.getInventoryOrganizationName().isEmpty()) {
            errorMsg.append("\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a;");
        } else {
            boolean result = false;
            for (LogicWarehouseOrgRespDto d : lists) {
                if (!d.getOrgName().equals(i.getInventoryOrganizationName())) continue;
                result = true;
                i.setInventoryOrganizationId(d.getOrgId());
                i.setInventoryOrganizationCode(d.getOrgCode());
                break;
            }
            if (!result) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u5e93\u5b58\u7ec4\u7ec7;");
            }
        }
        GetCarrierListPageParams para = new GetCarrierListPageParams();
        para.setPageNum(1);
        para.setPageSize(100);
        if (null != i.getReceivingCustomer() && !i.getReceivingCustomer().isEmpty()) {
            GetCustomerListPageParams pa = new GetCustomerListPageParams();
            pa.setPageNum(1);
            pa.setPageSize(100);
            pa.setOption(new ArrayList<Integer>(1));
            pa.setCustomerName(i.getReceivingCustomer());
            list = (PageInfo)this.basedataCenterCustomerService.getCustomerListPage(pa).getData();
            if (null == list) {
                errorMsg.append("\u6536\u8d27\u5ba2\u6237\u4e0d\u5b58\u5728;");
            } else {
                r = false;
                for (Object v : list.getList()) {
                    if (!((CustomerVO)v).getCustomerName().equals(i.getReceivingCustomer())) continue;
                    r = true;
                }
                if (!r) {
                    errorMsg.append("\u6536\u8d27\u5ba2\u6237\u4e0d\u5b58\u5728;");
                }
            }
        }
        if (null == i.getReceivingAddress() || i.getReceivingAddress().isEmpty()) {
            errorMsg.append("\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
        }
        this.fillRegion(i, errorMsg);
        if (null == i.getConsignmentNo() || i.getConsignmentNo().isEmpty()) {
            errorMsg.append("\u6258\u8fd0\u5355\u53f7\u4e3a\u7a7a;");
        }
        if (null != i.getDocumentNo() && !i.getDocumentNo().isEmpty()) {
            try {
                DailyDeliveryReportExtraDto b = (DailyDeliveryReportExtraDto)this.dailyDeliveryReportApi.getExtraBody(i.getDocumentNo()).getData();
                if (ObjectUtil.isEmpty((Object)b) || ObjectUtil.isEmpty((Object)b.getId())) {
                    errorMsg.append("\u672a\u67e5\u5230\u8be5\u51fa\u5e93\u901a\u77e5\u5355\u53f7;");
                }
            }
            catch (Exception e) {
                errorMsg.append("\u672a\u67e5\u5230\u8be5\u51fa\u5e93\u901a\u77e5\u5355\u53f7;");
            }
        } else {
            errorMsg.append("\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u4e3a\u7a7a;");
        }
        if (null == i.getTransportNo() || i.getTransportNo().isEmpty()) {
            errorMsg.append("\u627f\u8fd0\u5546\u5355\u53f7\u4e3a\u7a7a;");
        }
        if (null != i.getTotalQuantity() && !i.getTotalQuantity().isEmpty() && !i.getTotalQuantity().matches("\\d+")) {
            errorMsg.append("\u603b\u6570\u91cf\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e(\u53ea\u5305\u542b\u6570\u5b57);");
        }
        if (null != i.getTotalCartons() && !i.getTotalCartons().isEmpty()) {
            if (!i.getTotalCartons().matches("\\d+")) {
                errorMsg.append("\u603b\u4ef6\u6570\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e(\u53ea\u5305\u542b\u6570\u5b57);");
            }
        } else {
            errorMsg.append("WMS\u7bb1\u6570\u4e3a\u7a7a;");
        }
        if (null != i.getTotalVolume() && !i.getTotalVolume().isEmpty()) {
            if (i.getTotalVolume().matches("^\\d+(\\.\\d+)?$")) {
                if (!i.getTotalVolume().matches("^\\d+(\\.\\d{1,6})?$")) {
                    errorMsg.append("\u603b\u4f53\u79ef\u5c0f\u6570\u70b9\u4e0d\u8d85\u8fc76\u4f4d;");
                }
            } else {
                errorMsg.append("\u603b\u4f53\u79ef\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e(\u53ea\u5305\u542b\u6570\u5b57\u548c\u6700\u591a\u4e00\u4e2a\u5c0f\u6570\u70b9);");
            }
        } else {
            errorMsg.append("WMS\u4f53\u79ef\u4e3a\u7a7a;");
        }
        if (null != i.getTotalWeight() && !i.getTotalWeight().isEmpty()) {
            if (i.getTotalWeight().matches("^\\d+(\\.\\d+)?$")) {
                if (!i.getTotalWeight().matches("^\\d+(\\.\\d{1,6})?$")) {
                    errorMsg.append("\u603b\u91cd\u91cf\u5c0f\u6570\u70b9\u4e0d\u8d85\u8fc76\u4f4d;");
                }
            } else {
                errorMsg.append("\u603b\u91cd\u91cf\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e(\u53ea\u5305\u542b\u6570\u5b57\u548c\u6700\u591a\u4e00\u4e2a\u5c0f\u6570\u70b9);");
            }
        } else {
            errorMsg.append("WMS\u91cd\u91cf\u4e3a\u7a7a;");
        }
        Object vo = new CarrierVO();
        if (null == i.getShippingCompanyName() || i.getShippingCompanyName().isEmpty()) {
            errorMsg.append("\u7269\u6d41\u516c\u53f8\u4e3a\u7a7a;");
        } else {
            para.setCarrierName(i.getShippingCompanyName());
            list = (PageInfo)this.basedataCenterCarrierService.getCarrierListPage(para).getData();
            if (null == list) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u7269\u6d41\u516c\u53f8;");
            } else {
                r = false;
                for (Object v : list.getList()) {
                    if (!((CarrierVO)v).getCarrierName().equals(i.getShippingCompanyName())) continue;
                    r = true;
                    vo = v;
                    i.setShippingCompany(((CarrierVO)vo).getCarrierCode());
                }
                if (!r) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u7269\u6d41\u516c\u53f8;");
                }
            }
        }
        if (null == i.getTransportStyle() || i.getTransportStyle().isEmpty() || null == i.getShippingCompanyName() || i.getShippingCompanyName().isEmpty()) {
            errorMsg.append("\u7269\u6d41\u516c\u53f8+\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a;");
        } else {
            List<String> l = ((CarrierVO)vo).getLogisticsType();
            boolean result = false;
            if (null != l && !l.isEmpty()) {
                for (String s : l) {
                    if (!CsShipmentLogisticsTypeEnum.getDescByType((Integer)Integer.valueOf(s)).equals(i.getTransportStyle())) continue;
                    result = true;
                    i.setTransportStyleCode(s);
                    break;
                }
            }
            if (!result) {
                errorMsg.append("\u8be5\u7269\u6d41\u516c\u53f8+\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728;");
            }
        }
        if (!(null == i.getCommercialOrderFlag() || i.getCommercialOrderFlag().isEmpty() || i.getCommercialOrderFlag().equals("\u662f") || i.getCommercialOrderFlag().equals("\u5426"))) {
            errorMsg.append("\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u4e3a\u7535\u5546\u5355;");
        }
        if (null != i.getLongCode() && !i.getLongCode().isEmpty()) {
            GetGoodsListPageParams pa = new GetGoodsListPageParams();
            pa.setPageNum(1);
            pa.setPageSize(1);
            pa.setGoodsLongCode(i.getLongCode());
            PageInfo list2 = (PageInfo)this.basedataCenterGoodsService.getGoodsListPage(pa).getData();
            if (null == list2) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u4fe1\u606f");
            }
        }
        if (null != i.getBatch() && !i.getBatch().isEmpty() && !i.getBatch().matches("^[a-zA-Z0-9-]+$")) {
            errorMsg.append("\u6279\u6b21\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e(\u53ea\u5305\u542b\u6570\u5b57\u548c\u82f1\u6587\u548c\"-\");");
        }
        if (null != i.getQuantity() && !i.getQuantity().isEmpty() && !i.getTotalCartons().matches("\\d+")) {
            errorMsg.append("\u51fa\u5e93\u6570\u91cf\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e(\u53ea\u5305\u542b\u6570\u5b57);");
        }
        i.setErrorMsg(errorMsg.toString());
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportDailyDeliveryReportOneVO vo) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(vo, "\u6570\u636e\u91cd\u590d;");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(ImportDailyDeliveryReportOneVO msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    private Long createOrder(ImportDailyDeliveryReportOneVO v) {
        DailyDeliveryReportDto d = new DailyDeliveryReportDto();
        d.setDataSource(DailyDeliveryReportDataSourceEnum.ONE_IMP.getCode());
        Optional.ofNullable(v).ifPresent(val -> {
            d.setInventoryOrganizationName(val.getInventoryOrganizationName());
            d.setInventoryOrganizationCode(val.getInventoryOrganizationCode());
            d.setReceivingCustomer(val.getReceivingCustomer());
            d.setReceivingAddress(val.getReceivingAddress());
            d.setReceivingPerson(val.getReceivingPerson());
            d.setReceivingPersonPhone(val.getReceivingPersonPhone());
            d.setReceivingAddressProvince(val.getReceivingAddressProvince());
            d.setReceivingAddressProvinceCode(val.getReceivingAddressProvinceCode());
            d.setReceivingAddressCity(val.getReceivingAddressCity());
            d.setReceivingAddressCityCode(val.getReceivingAddressCityCode());
            d.setReceivingAddressDistrict(val.getReceivingAddressDistrict());
            d.setReceivingAddressDistrictCode(val.getReceivingAddressDistrictCode());
            d.setConsignmentNo(val.getConsignmentNo());
            d.setOutNoticeNo(val.getDocumentNo());
            d.setTransportNo(val.getTransportNo());
            d.setTotalQuantity(Optional.ofNullable(val).map(ImportDailyDeliveryReportOneVO::getTotalQuantity).map(BigDecimal::new).orElse(BigDecimal.ZERO));
            d.setTotalCartons(Optional.ofNullable(val).map(ImportDailyDeliveryReportOneVO::getTotalCartons).map(BigDecimal::new).orElse(BigDecimal.ZERO));
            d.setTotalVolume(Optional.ofNullable(val).map(ImportDailyDeliveryReportOneVO::getTotalVolume).map(BigDecimal::new).orElse(BigDecimal.ZERO));
            d.setTotalWeight(Optional.ofNullable(val).map(ImportDailyDeliveryReportOneVO::getTotalWeight).map(BigDecimal::new).orElse(BigDecimal.ZERO));
            d.setShippingCompanyName(val.getShippingCompanyName());
            d.setShippingCompany(val.getShippingCompany());
            d.setShipmentEnterpriseCode(val.getShippingCompany());
            d.setShipmentEnterpriseName(val.getShippingCompanyName());
            d.setTransportStyleCode(val.getTransportStyleCode());
            d.setTransportStyle(val.getTransportStyle());
            d.setVehicleNumber(val.getVehicleNumber());
            d.setCommercialOrderFlag(Integer.valueOf("\u662f".equals(val.getCommercialOrderFlag()) ? 1 : 0));
            d.setShopName(val.getShopName());
            d.setRemark(val.getRemark());
            d.setMuchDeliveryFlag(Integer.valueOf(1));
            d.setBillingCartons(d.getTotalCartons());
            d.setBillingVolume(d.getTotalVolume());
            d.setBillingWeight(d.getTotalWeight());
        });
        log.info("\u5f00\u59cb\u8865\u5145\u5b57\u6bb5");
        DailyDeliveryReportExtraDto b = (DailyDeliveryReportExtraDto)this.dailyDeliveryReportApi.getExtraBody(v.getDocumentNo()).getData();
        Optional.ofNullable(b).ifPresent(val -> {
            d.setRelevanceNo(val.getRelevanceNo());
            d.setBusinessType(val.getBusinessType());
            d.setOrderCreateTime(val.getOrderCreateTime());
            d.setOrderShippingTime(val.getOrderShippingTime());
            d.setOutNoticeNo(val.getOutNoticeNo());
            d.setOutResultNo(val.getOutResultNo());
            d.setEasOrderNo(val.getEasOrderNo());
            d.setPhysicalWarehouse(val.getPhysicalWarehouse());
            d.setPhysicalWarehouseCode(val.getPhysicalWarehouseCode());
            d.setLogicWarehouse(val.getLogicWarehouse());
            d.setLogicWarehouseCode(val.getLogicWarehouseCode());
            d.setInPhysicalWarehouse(val.getInPhysicalWarehouse());
            d.setInPhysicalWarehouseCode(val.getInPhysicalWarehouseCode());
            d.setInLogicWarehouse(val.getInLogicWarehouse());
            d.setInLogicWarehouseCode(val.getInLogicWarehouseCode());
            d.setInInventoryOrg(val.getInInventoryOrg());
            d.setInInventoryOrgId(val.getInInventoryOrgId());
            d.setOutInventoryOrg(val.getOutInventoryOrg());
            d.setOutInventoryOrgId(val.getOutInventoryOrgId());
            d.setStartCity(val.getStartCity());
            d.setStartProvince(val.getStartProvince());
            d.setStartCityCode(val.getStartCityCode());
            d.setStartProvinceCode(val.getStartProvinceCode());
            d.setDocumentNo(val.getDocumentNo());
            d.setWmsOrderType("OCS");
        });
        log.error("\u65b0\u589e\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)d));
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.addDailyDeliveryReport(d));
        return id;
    }

    private void createDetail(ImportDailyDeliveryReportOneVO v, Long reportId) {
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)v.getQuantity()), "\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        DailyDeliveryReportDetailProductDto productDto = new DailyDeliveryReportDetailProductDto();
        productDto.setDailyDeliveryReportId(reportId);
        Optional.ofNullable(v).ifPresent(val -> {
            productDto.setLongCode(val.getLongCode());
            productDto.setBatch(val.getBatch());
            productDto.setQuantity(new BigDecimal(val.getQuantity()));
            productDto.setProductName(val.getProductName());
            productDto.setCartonQuantity(val.getCartonQuantity());
            productDto.setSmallBottles(val.getSmallBottles());
            productDto.setWeight(val.getWeight());
            productDto.setVolume(val.getVolume());
            productDto.setInternalTransaction(val.getInternalTransaction());
            productDto.setRecommendPrice(val.getRecommendPrice());
            productDto.setDr(Integer.valueOf(0));
        });
        log.error("\u65b0\u589e\u4e00\u5355\u591a\u53d1\u5bfc\u5165\u660e\u7ec6\uff1a{}" + JSON.toJSONString((Object)productDto));
        RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.add(productDto));
    }

    private void fillRegion(ImportDailyDeliveryReportOneVO vo, StringBuilder errorMsg) {
        List baseAres = (List)this.basedataCenterAreaService.getBaseAreaTreeByLevel("3").getData();
        if (CollectionUtil.isEmpty((Collection)baseAres)) {
            errorMsg.append("\u7cfb\u7edf\u7f3a\u5c11\u884c\u653f\u533a\u57df\u4fe1\u606f;");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getReceivingAddressProvince())) {
                BaseAreaVO province = baseAres.stream().filter(f -> f.getName().equals(vo.getReceivingAddressProvince())).findFirst().orElse(null);
                if (ObjectUtil.isEmpty((Object)province)) {
                    errorMsg.append("\u5339\u914d\u7701\u4efd\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u7701\u4efd\u4fe1\u606f;");
                    return;
                }
                vo.setReceivingAddressProvinceCode(province.getCode());
                if (StringUtils.isNotBlank((CharSequence)vo.getReceivingAddressCity())) {
                    if (CollectionUtil.isEmpty(province.getChildren())) {
                        errorMsg.append("\u5339\u914d\u57ce\u5e02\u5f02\u5e38\uff0c\u7cfb\u7edf\u7f3a\u5c11\u57ce\u5e02\u4fe1\u606f");
                        return;
                    }
                    BaseAreaVO city = province.getChildren().stream().filter(f -> f.getName().equals(vo.getReceivingAddressCity())).findFirst().orElse(null);
                    if (ObjectUtil.isEmpty((Object)city)) {
                        errorMsg.append("\u5339\u914d\u57ce\u5e02\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u57ce\u5e02\u4fe1\u606f;");
                        return;
                    }
                    vo.setReceivingAddressCityCode(city.getCode());
                    if (StringUtils.isNotBlank((CharSequence)vo.getReceivingAddressDistrict())) {
                        if (CollectionUtil.isEmpty(city.getChildren())) {
                            errorMsg.append("\u5339\u914d\u533a\u57df\u5f02\u5e38\uff0c\u7cfb\u7edf\u7f3a\u5c11\u533a\u57df\u4fe1\u606f");
                            return;
                        }
                        BaseAreaVO district = city.getChildren().stream().filter(f -> f.getName().equals(vo.getReceivingAddressDistrict())).findFirst().orElse(null);
                        if (ObjectUtil.isEmpty((Object)district)) {
                            errorMsg.append("\u5339\u914d\u533a\u57df\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u533a\u57df\u4fe1\u606f;");
                            return;
                        }
                        vo.setReceivingAddressDistrictCode(district.getCode());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5339\u914d\u7701\u5e02\u533a\u5f02\u5e38:" + e);
            errorMsg.append("\u5339\u914d\u7701\u5e02\u533a\u5f02\u5e38\uff1a").append(e.getMessage()).append(";");
        }
    }
}

