/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.reader;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.starter.bundle.common.BundleDescConstants;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.UrlResource;
import org.springframework.util.CollectionUtils;

public abstract class AbstractBundleReader<BUNDLE_DATA extends BundleBaseDto> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBundleReader.class);
    protected static final Set<String> bundleLoadedSet = new HashSet<String>();
    protected Map<String, BUNDLE_DATA> artifactMap = new HashMap<String, BUNDLE_DATA>();

    private static String parseBasePathFromUrl(URL url, String filename) {
        String path = url.getPath().replaceFirst("/", "");
        logger.info("\u622a\u53d6\u4e4b\u524d\u7684\u529f\u80fd\u5305path\uff1a{}", (Object)path);
        if (path.endsWith("/target/classes/" + filename)) {
            path = path.substring(0, path.lastIndexOf("/target/classes/" + filename));
            path = path.substring(path.lastIndexOf("/") + 1);
        } else {
            path = path.substring(0, path.lastIndexOf("!/" + filename));
            path = path.substring(path.lastIndexOf("/") + 1);
        }
        logger.info("\u622a\u53d6\u4e4b\u540e\u7684\u529f\u80fd\u5305module\u6807\u8bc6\uff1a{}", (Object)path);
        return path;
    }

    public static <T> void append(String key, JSONObject jsonObject, List<T> list, Class<T> clz) {
        JSONArray jsonArray = jsonObject.getJSONArray(key);
        if (jsonArray == null) {
            return;
        }
        list.addAll(jsonArray.stream().filter(object -> object != null && object instanceof JSONObject).map(object -> {
            JSONObject tmpJsonObject = (JSONObject)object;
            return AbstractBundleReader.convert(tmpJsonObject, clz);
        }).collect(Collectors.toList()));
    }

    public static <T> T convert(JSONObject jsonObject, Class<T> clz) {
        return (T)jsonObject.toJavaObject(clz);
    }

    public static String removeAfterFix(String artifactId) {
        if (artifactId == null) {
            return "";
        }
        if (artifactId.endsWith("eo")) {
            artifactId = artifactId.substring(0, artifactId.length() - 2);
        }
        if (artifactId.endsWith("api") || artifactId.endsWith("biz") || artifactId.endsWith("dao") || artifactId.endsWith("ext") || artifactId.endsWith("web")) {
            artifactId = artifactId.substring(0, artifactId.length() - 3);
        }
        if (artifactId.endsWith("conf")) {
            artifactId = artifactId.substring(0, artifactId.length() - 4);
        }
        if (artifactId.endsWith("service")) {
            artifactId = artifactId.substring(0, artifactId.length() - 7);
        }
        return artifactId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUNDLE_DATA getBundleInstance(Map<String, BUNDLE_DATA> artifactMap, String groupId, String artifactId, String version) {
        String key = BundleDescConstants.getBundleKey(groupId, artifactId, version);
        BundleBaseDto bundleDescRespDto = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            bundleDescRespDto = (BundleBaseDto)artifactMap.get(key);
        }
        if (bundleDescRespDto == null) {
            bundleDescRespDto = this.generate();
            bundleDescRespDto.setArtifactId(artifactId);
            bundleDescRespDto.setGroupId(groupId);
            bundleDescRespDto.setVersion(version);
            artifactMap.put(key, bundleDescRespDto);
        }
        return (BUNDLE_DATA)bundleDescRespDto;
    }

    protected void read(Map<String, BUNDLE_DATA> artifactMap, String fileName, Boolean weakDependLoadedFlag) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> jsonFiles = classLoader.getResources(fileName);
            logger.info("\u5f53\u524d\u6267\u884c\u529f\u80fd\u5305\u63cf\u8ff0\u6587\u4ef6\u662f:{}", (Object)fileName);
            while (jsonFiles.hasMoreElements()) {
                URL url = jsonFiles.nextElement();
                logger.info("\u6587\u4ef6\u7684\u8def\u5f84:{}", (Object)url.getPath());
                UrlResource resource = new UrlResource(url);
                StringBuilder json = new StringBuilder();
                boolean fileSkippedFlag = false;
                String modulePostfix = null;
                if ("META-INF/bundle-api.json".equals(fileName) || "META-INF/bundle-dto.json".equals(fileName)) {
                    fileSkippedFlag = true;
                    modulePostfix = "api";
                } else if ("META-INF/bundle-dto-domain-event.json".equals(fileName)) {
                    fileSkippedFlag = true;
                    modulePostfix = "event";
                }
                if (!weakDependLoadedFlag.booleanValue() && fileSkippedFlag) {
                    String path = AbstractBundleReader.parseBasePathFromUrl(url, fileName);
                    if (path.endsWith(modulePostfix)) {
                        path = path.substring(0, path.lastIndexOf(modulePostfix));
                    }
                    if (path.endsWith(".jar") && path.contains(modulePostfix)) {
                        path = path.substring(0, path.lastIndexOf(modulePostfix));
                    }
                    boolean flag = false;
                    if (CollectionUtils.isEmpty(bundleLoadedSet)) {
                        flag = true;
                    } else {
                        for (String bundle : bundleLoadedSet) {
                            if (!bundle.startsWith(path)) continue;
                            flag = true;
                            logger.info("\u5f3a\u4f9d\u8d56API\u5c42\u6587\u4ef6\u5c06\u8981\u4e0a\u62a5\uff1a{}", (Object)url.getPath());
                            break;
                        }
                    }
                    if (!flag) {
                        logger.info("\u5f31\u4f9d\u8d56API\u5c42\u6587\u4ef6\u4e0d\u4e0a\u62a5\uff1a{}", (Object)url.getPath());
                        continue;
                    }
                }
                IOUtils.readLines((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8).forEach(json::append);
                logger.debug("\u6587\u4ef6\u5185\u5bb9\uff1a{}", (Object)json);
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)json.toString());
                    String groupId = jsonObject.getString("groupId");
                    String artifactId = AbstractBundleReader.removeAfterFix(jsonObject.getString("artifactId"));
                    String version = jsonObject.getString("version");
                    BUNDLE_DATA bundleBaseDto = this.getBundleInstance(artifactMap, groupId, artifactId, version);
                    this.jsonConvert(bundleBaseDto, jsonObject);
                }
                catch (Throwable throwable) {
                    logger.info("{}\u6587\u4ef6\u5185\u5bb9\u89e3\u6790\u6210json\u5f02\u5e38\uff1a", (Object)fileName, (Object)throwable);
                }
            }
        }
        catch (Exception e) {
            logger.warn("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public abstract BUNDLE_DATA generate();

    public abstract void jsonConvert(BUNDLE_DATA var1, JSONObject var2);

    public abstract Map<String, BUNDLE_DATA> process(Boolean var1);
}

