/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.constants;

import java.util.HashMap;
import java.util.Map;

public enum BundleType {
    FRONTEND("frontend", "frontendFlag", "\u524d\u7aef\u5e94\u7528"),
    BACKEND("backend", "backendFlag", "\u540e\u7aef\u5e94\u7528"),
    CENTER("center", "centerFlag", "\u80fd\u529b\u4e2d\u5fc3");

    private final String frontendName;
    private final String dbFieldName;
    private final String typeDesc;
    private static final Map<String, BundleType> frontendNameMap;

    private BundleType(String frontendName, String dbFieldName, String typeDesc) {
        this.frontendName = frontendName;
        this.dbFieldName = dbFieldName;
        this.typeDesc = typeDesc;
    }

    public static BundleType getByFrontendName(String frontendName) {
        return frontendNameMap.get(frontendName);
    }

    public String getFrontendName() {
        return this.frontendName;
    }

    public String getDbFieldName() {
        return this.dbFieldName;
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    static {
        frontendNameMap = new HashMap<String, BundleType>(8);
        for (BundleType bundleType : BundleType.values()) {
            frontendNameMap.put(bundleType.getFrontendName(), bundleType);
        }
    }
}

