/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.das;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.AbstractBaseDas;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.mapper.FuncCommonMapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.type.SqlEnum;
import com.dtyunxi.util.IdGenrator;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuncMyAbstractDas<T extends BaseEo, P>
extends AbstractBaseDas<T, P> {
    protected Logger logger = LoggerFactory.getLogger(FuncMyAbstractDas.class);
    protected FuncCommonMapper<T> commonMapper;

    public FuncMyAbstractDas(FuncCommonMapper<T> commonMapper) {
        this.commonMapper = commonMapper;
    }

    public Long getId() {
        return IdGenrator.getDistributedId();
    }

    public List<T> findLimitListWithColumn(T selectParam, Integer pageNum, Integer pageSize, String ... columns) {
        try {
            List<T> list = this.commonMapper.findLimitListWithColumn(selectParam, pageNum, pageSize, SqlEnum.mySql, columns);
            return list;
        }
        catch (Exception e) {
            this.logger.error("\u6307\u5b9a\u5217\u67e5\u8be2\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public List<T> findListWithColumn(T selectParam, String ... columns) {
        try {
            List<T> list = this.commonMapper.findListWithColumn(selectParam, columns);
            return list;
        }
        catch (Exception e) {
            this.logger.error("\u6307\u5b9a\u5217\u67e5\u8be2\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public PageInfo<T> selectPageWithExtSql(T record, Integer currentPage, Integer pageSize, String extSqlCondiction) {
        if (StrUtil.isNotBlank((CharSequence)extSqlCondiction)) {
            record.setExtWhere(extSqlCondiction);
        }
        return super.selectPage(record, currentPage, pageSize);
    }

    public List<T> selectWithExtSql(T record, String extSqlCondiction) {
        if (StrUtil.isNotBlank((CharSequence)extSqlCondiction)) {
            record.setExtWhere(extSqlCondiction);
        }
        return super.select(record);
    }

    public void physicalDelete(T record) {
        this.commonMapper.physicalDelete(record);
    }

    public PageInfo<T> selectOffset(T record, Integer offset, Integer limit) {
        PageHelper.offsetPage((int)offset, (int)limit);
        List list = this.getMapper().findList(record);
        return new PageInfo(list);
    }

    public void batchUpdateInJoin(int batchSize, @Param(value="objList") List<T> list) {
        int updateSize = list.size();
        if (updateSize > batchSize) {
            this.commonMapper.batchUpdateInJoin(list.subList(0, batchSize));
            int loop = updateSize / batchSize;
            int lastNum = updateSize - loop * batchSize;
            int nextFromIndex = batchSize;
            for (int i = 1; i < loop; ++i) {
                this.commonMapper.batchUpdateInJoin(list.subList(nextFromIndex, nextFromIndex + batchSize));
                nextFromIndex = batchSize * ++i;
            }
            if (lastNum > 0) {
                this.commonMapper.batchUpdateInJoin(list.subList(nextFromIndex, nextFromIndex + lastNum));
            }
        } else if (CollectionUtils.isNotEmpty(list)) {
            this.commonMapper.batchUpdateInJoin(list);
        }
    }
}

