/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.mapper;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.ds.BaseEoUtil;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.util.ReflectionUtils;

public class FuncMySqlTemplate<T extends BaseEo> {
    private static final String myOpenToken = "#\\{";
    private static final String myOpenToken$ = "$\\{";

    public String batchUpdateInJoin(@Param(value="objList") List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        StringBuilder update = new StringBuilder("update ").append(BaseEoUtil.tableName(((BaseEo)list.get(0)).getClass())).append(" a JOIN(");
        HashMap columns = Maps.newHashMap();
        this.appendJoinUpdateSql(update, columns, (BaseEo)list.get(0));
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            update.append(" UNION ");
            this.appendJoinUpdateSql(update, columns, (BaseEo)list.get(i));
        }
        update.append(") b USING(id) SET ");
        for (String column : columns.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)column)) continue;
            update.append("a.").append(column).append("=").append("b.").append(column).append(",");
        }
        update.deleteCharAt(update.length() - 1);
        update.append(";");
        String updateSqlStr = update.toString();
        if (StringUtils.isNotBlank((CharSequence)updateSqlStr)) {
            updateSqlStr = updateSqlStr.replaceAll(myOpenToken, "# {");
            updateSqlStr = updateSqlStr.replaceAll(myOpenToken$, "$ {");
        }
        return updateSqlStr;
    }

    private void appendJoinUpdateSql(StringBuilder update, Map<String, String> columns, T obj) {
        update.append("SELECT ");
        ReflectionUtils.doWithFields(obj.getClass(), field -> {
            if (!("serialVersionUID".equals(field.getName()) || "dr".equals(field.getName()) || "createTime".equals(field.getName()) || "createPerson".equals(field.getName()))) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                Transient notColunm = field.getAnnotation(Transient.class);
                if (notColunm == null) {
                    Column column = field.getAnnotation(Column.class);
                    String columnName = null;
                    columnName = column == null ? field.getName() : column.name();
                    if (StringUtils.isNotBlank((CharSequence)columnName)) {
                        Object value = field.get(obj);
                        if (value instanceof String) {
                            update.append("'").append(value == null ? null : ((String)value).replaceAll("'", "\\\\'")).append("' ").append(columnName).append(",");
                        } else if (value instanceof Date) {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            update.append("'").append(simpleDateFormat.format(value)).append("' ").append(columnName).append(",");
                        } else {
                            update.append(value).append(" ").append(columnName).append(",");
                        }
                        columns.put(columnName, "");
                    }
                }
                field.setAccessible(accessible);
            }
        });
        update.deleteCharAt(update.length() - 1);
    }
}

