/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.mq;

import com.dtyunxi.cube.notifier.api.NotifierFeignClientCaller;
import com.dtyunxi.cube.notifier.config.NotifierFeignClientConfig;
import com.dtyunxi.cube.starter.bundle.api.PullBundleDescriptionApi;
import com.dtyunxi.cube.starter.bundle.config.BundleReportModeConfig;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.starter.bundle.dto.request.BundleDescReqDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.enums.BundleReportModeEnum;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.config.BundleBootMqConsumerConfig;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.dto.AppStartedRecordReqDto;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.enums.AppStartedPullStatus;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.AppStartedRecordEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleSyncService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IStarterAppStartedRecordService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractBundleBootMqProcess<T extends BundleBaseDto>
implements IMessageProcessor<BundleDescDto<Map<String, T>>> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBundleBootMqProcess.class);
    @Value(value="${app.started.lock.wait.timeout:600}")
    protected int waitTimeout;
    @Value(value="${app.started.lock.lease.time:300}")
    protected int leaseTime;
    @Qualifier(value="notifierFeignClientConfig")
    @Autowired(required=false)
    protected NotifierFeignClientConfig feignClientConfig = new NotifierFeignClientConfig();
    protected IBundleSyncService bundleSyncService;
    protected boolean newMode = true;
    @Resource
    protected Map<String, IStarterAppStartedRecordService> appStartedRecordServiceMap;
    protected IStarterAppStartedRecordService starterAppStartedRecordService;
    @Resource
    protected ILockService lockService;
    @Resource
    protected BundleBootMqConsumerConfig bundleBootMqConsumerConfig;
    @Resource
    protected BundleReportModeConfig bundleReportModeConfig;
    protected BundleDataTypeEnum bundleDataType;

    public AbstractBundleBootMqProcess(IBundleSyncService bundleSyncService, BundleDataTypeEnum bundleDataType) {
        this.bundleSyncService = bundleSyncService;
        this.bundleDataType = bundleDataType;
    }

    public void setNewMode(boolean newMode) {
        this.newMode = newMode;
    }

    public abstract T newBeanInstance();

    public abstract RestResponse<List<T>> restCall(PullBundleDescriptionApi var1, BundleDescReqDto var2);

    public Mutex getMutex(BundleDescDto<Map<String, T>> message) {
        Mutex mutex = null;
        try {
            String key = message.getServiceId() + message.getApplicationVersion();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-ddHH:mm:ss");
            mutex = this.lockService.lock(key, simpleDateFormat.format(message.getBootTime()), this.waitTimeout, this.leaseTime, TimeUnit.SECONDS);
        }
        catch (BusinessRuntimeException businessRuntimeException) {
            logger.info("\u5f53\u524d\u7248\u672c\u7684\u5e94\u7528\u4e0a\u62a5\u4fe1\u606f\u5df2\u7ecf\u5728\u5904\u7406\u4e2d\uff0cserviceId:{}, version:{}, bootTime:{}", new Object[]{message.getServiceId(), message.getApplicationVersion(), message.getBootTime()});
        }
        return mutex;
    }

    public abstract boolean ignoreConsumer();

    public abstract int reportMode();

    public void preProcess(BundleDescDto<Map<String, T>> message, List<T> dataList) {
    }

    public BundleDataTypeEnum getBundleDataType() {
        return this.bundleDataType;
    }

    private boolean illegalDataType(int type) {
        return this.bundleDataType.getKey() != type;
    }

    public IStarterAppStartedRecordService getStarterAppStartedRecordService() {
        if (this.starterAppStartedRecordService == null) {
            this.appStartedRecordServiceMap.forEach((name, bean) -> {
                if (!name.equals("starterAppStartedRecordService")) {
                    this.starterAppStartedRecordService = bean;
                }
            });
            if (this.starterAppStartedRecordService == null) {
                this.starterAppStartedRecordService = this.appStartedRecordServiceMap.get("starterAppStartedRecordService");
            }
        }
        return this.starterAppStartedRecordService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(BundleDescDto<Map<String, T>> message) {
        MessageResponse messageResponse;
        Mutex mutex;
        block15: {
            if (this.ignoreConsumer()) {
                logger.info("\u4e0d\u6d88\u8d39\u529f\u80fd\u5305\u4e0a\u62a5\u7684{}\u6570\u636e", (Object)this.bundleDataType);
                return MessageResponse.SUCCESS;
            }
            if (this.illegalDataType(message.getType())) {
                logger.warn("\u975e\u6cd5\u7684\u6570\u636e\u7c7b\u578b[\u671f\u5f85\u7c7b\u578b\uff1a{}-{}\uff0c\u5f53\u524d\u7c7b\u578b\uff1a{}]\uff0c\u4e0d\u6d88\u8d39", new Object[]{this.bundleDataType.getDesc(), this.bundleDataType.getKey(), message.getType()});
                return MessageResponse.SUCCESS;
            }
            for (BundleDataTypeEnum bundleDataType : BundleDataTypeEnum.values()) {
                if (bundleDataType.getKey() == message.getType()) break;
            }
            logger.info("\u5f00\u59cb\u5904\u7406\u5e94\u7528\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\uff0cserviceId={}\uff0cip={}\uff0cport={}\uff0cversoin={},dataType={}", new Object[]{message.getServiceId(), message.getIp(), message.getPort(), message.getApplicationVersion(), this.bundleDataType});
            mutex = null;
            mutex = this.getMutex(message);
            if (null == mutex) break block15;
            logger.info("mutex key:{}, acq:{}, threadId:{}", new Object[]{mutex.getLockKey(), mutex.getLockAcquirer(), Thread.currentThread().getId()});
            this.dealMessage(message);
            logger.info("\u5e94\u7528[{}]\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\u5904\u7406\u5b8c\u6bd5", (Object)this.bundleDataType);
            MessageResponse messageResponse2 = MessageResponse.SUCCESS;
            logger.info("unlock mutex key:{}, acq:{}, threadId:{}", new Object[]{mutex.getLockKey(), mutex.getLockAcquirer(), Thread.currentThread().getId()});
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
            return messageResponse2;
        }
        try {
            logger.error("\u5e94\u7528[{}]\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\uff0cserviceId={}\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Object)this.bundleDataType, (Object)message.getServiceId());
            messageResponse = MessageResponse.ERROR;
        }
        catch (Exception e) {
            MessageResponse messageResponse3;
            block16: {
                try {
                    logger.error("\u5e94\u7528{}:{}:{} \u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\u5904\u7406\u5931\u8d25", new Object[]{message.getServiceId(), this.bundleDataType, message.getBootTime(), e});
                    AppStartedRecordEo appStartedRecordEo = this.getStarterAppStartedRecordService().findAppStartRecord(this.toAppStartedRecordReqDto(message));
                    if (null != appStartedRecordEo) {
                        this.getStarterAppStartedRecordService().modifyStatusById(appStartedRecordEo.getId(), message.getType(), AppStartedPullStatus.FAILED.name(), message.getBundleDataUploadDto());
                    }
                    if (!this.bundleBootMqConsumerConfig.isErrorIgnore()) break block16;
                    logger.warn("[{}]bundle.mq.consume.error.ignore\u503c\u4e3a\uff1a{}, \u5f3a\u5236\u8fd4\u56de\u6d88\u8d39\u6210\u529f", (Object)this.bundleDataType, (Object)this.bundleBootMqConsumerConfig.isErrorIgnore());
                    messageResponse3 = MessageResponse.SUCCESS;
                }
                catch (Throwable throwable) {
                    logger.info("unlock mutex key:{}, acq:{}, threadId:{}", new Object[]{mutex.getLockKey(), mutex.getLockAcquirer(), Thread.currentThread().getId()});
                    if (null != mutex) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
                logger.info("unlock mutex key:{}, acq:{}, threadId:{}", new Object[]{mutex.getLockKey(), mutex.getLockAcquirer(), Thread.currentThread().getId()});
                if (null != mutex) {
                    this.lockService.unlock(mutex);
                }
                return messageResponse3;
            }
            messageResponse3 = MessageResponse.ERROR;
            logger.info("unlock mutex key:{}, acq:{}, threadId:{}", new Object[]{mutex.getLockKey(), mutex.getLockAcquirer(), Thread.currentThread().getId()});
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
            return messageResponse3;
        }
        logger.info("unlock mutex key:{}, acq:{}, threadId:{}", new Object[]{mutex.getLockKey(), mutex.getLockAcquirer(), Thread.currentThread().getId()});
        if (null != mutex) {
            this.lockService.unlock(mutex);
        }
        return messageResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long dealMessage(BundleDescDto<Map<String, T>> message) {
        boolean needConsume = this.isNeedConsume(message);
        Long appStartedRecordId = this.getStarterAppStartedRecordService().addAppStartedRecord(this.toAppStartedRecordReqDto(message));
        if (!needConsume) {
            logger.info("\u5e94\u7528[{}]\u7248\u672c[{}]\u548c\u6253\u5305\u65f6\u95f4[{}]\u672a\u53d8\uff0c\u4e0d\u9700\u8981\u62c9\u53d6\u5e94\u7528\u7684\u529f\u80fd\u5305[{}]\u7269\u6599", new Object[]{message.getServiceId(), message.getApplicationVersion(), message.getApplicationCreateTime(), this.bundleDataType});
            this.getStarterAppStartedRecordService().modifyStatusById(appStartedRecordId, message.getType(), AppStartedPullStatus.DONE.name(), message.getBundleDataUploadDto());
            return appStartedRecordId;
        }
        List<T> dataList = this.readData(message);
        if (dataList == null) {
            dataList = new ArrayList<T>();
        }
        this.preProcess(message, dataList);
        this.bundleSyncService.handle(dataList, this.bundleDataType);
        this.postProcess(message);
        this.getStarterAppStartedRecordService().modifyStatusById(appStartedRecordId, message.getType(), AppStartedPullStatus.DONE.name(), message.getBundleDataUploadDto());
        return appStartedRecordId;
    }

    public void postProcess(BundleDescDto<Map<String, T>> message) {
        this.bundleSyncService.bundlePostProcessService().do4Service(message.getServiceId());
    }

    protected List<T> readData(BundleDescDto<Map<String, T>> message) {
        List<Object> dataList = null;
        if (BundleReportModeEnum.MQ_REST.getKey() == this.reportMode() && this.newMode) {
            NotifierFeignClientCaller feignClientApiCaller;
            RestResponse restResponse;
            BundleDescReqDto param = new BundleDescReqDto();
            if (message.getIp().indexOf("/") != -1) {
                message.setIp(message.getIp().split("/")[1]);
            }
            if (null != (restResponse = (RestResponse)(feignClientApiCaller = new NotifierFeignClientCaller()).process(pullBundleDescriptionApi -> this.restCall((PullBundleDescriptionApi)pullBundleDescriptionApi, param), message.getIp(), message.getPort(), PullBundleDescriptionApi.class, this.feignClientConfig))) {
                dataList = (List)restResponse.getData();
            }
            logger.info("\u5e94\u7528\u529f\u80fd\u5305[{}]\u7269\u6599\u5df2\u62c9\u53d6", (Object)this.bundleDataType);
        } else {
            Map content = (Map)message.getContent();
            if (content != null) {
                dataList = new ArrayList(content.values());
            }
            logger.info("\u4ece\u6d88\u606f\u4f53\u83b7\u53d6\u5e94\u7528\u529f\u80fd\u5305[{}]\u7269\u6599", (Object)this.bundleDataType);
        }
        if (dataList == null) {
            dataList = new ArrayList();
        }
        return dataList;
    }

    private AppStartedRecordReqDto toAppStartedRecordReqDto(BundleDescDto message) {
        AppStartedRecordReqDto appStartedRecordReqDto = new AppStartedRecordReqDto();
        appStartedRecordReqDto.setCode(message.getServiceId());
        appStartedRecordReqDto.setVersion(message.getApplicationVersion());
        appStartedRecordReqDto.setPackageTime(message.getApplicationCreateTime());
        appStartedRecordReqDto.setIp(message.getIp());
        appStartedRecordReqDto.setPort(message.getPort());
        appStartedRecordReqDto.setStatus(AppStartedPullStatus.DOING.name());
        appStartedRecordReqDto.setType(message.getType());
        appStartedRecordReqDto.setBootTime(message.getBootTime());
        return appStartedRecordReqDto;
    }

    private boolean isNeedConsume(BundleDescDto message) {
        if (StringUtils.isBlank((CharSequence)message.getApplicationVersion())) {
            logger.info("\u8bf7\u6c42\u7684\u5e94\u7528\u7248\u672c\u4e3a\u7a7a,\u9700\u8981\u6d88\u8d39");
            return true;
        }
        if (null == message.getApplicationCreateTime()) {
            logger.info("\u8bf7\u6c42\u7684\u5e94\u7528\u6253\u5305\u65f6\u95f4\u4e3a\u7a7a,\u9700\u8981\u6d88\u8d39");
            return true;
        }
        return !this.getStarterAppStartedRecordService().existsFinishedDataType(message.getApplicationCreateTime(), message.getApplicationVersion(), message.getServiceId(), message.getType());
    }

    public Long getId() {
        return IdGenrator.getDistributedId();
    }
}

