/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.mq;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.starter.bundle.api.PullBundleDescriptionApi;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.starter.bundle.dto.request.BundleDescReqDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleBaseSettingRespDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.mq.AbstractBundleBootMqProcess;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IAppBundleUpdateService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleSyncService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.AppBundleReqDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"bundleReportModeConfig"})
@MQDesc(topic="${dtyunxi.bundle.mq.bundle_base_setting.topic:PUBLISH_TOPIC}", tag="${dtyunxi.bundle.mq.bundle_base_setting.tag:BUNDLE_BASE_SETTING_TAG}", msgType="publish")
public class BundleBootBaseSettingProcess
extends AbstractBundleBootMqProcess<BundleBaseSettingRespDto> {
    protected IAppBundleUpdateService appBundleService;

    public BundleBootBaseSettingProcess(@Qualifier(value="bundleBaseSettingSyncService") IBundleSyncService bundleSyncService, @Autowired(required=false) IAppBundleUpdateService appBundleService) {
        super(bundleSyncService, BundleDataTypeEnum.BASE_SETTING);
        this.appBundleService = appBundleService;
    }

    @Override
    public BundleBaseSettingRespDto newBeanInstance() {
        return new BundleBaseSettingRespDto();
    }

    @Override
    public boolean ignoreConsumer() {
        return !this.bundleBootMqConsumerConfig.isBaseSetting();
    }

    @Override
    public int reportMode() {
        return this.bundleReportModeConfig.getBasic();
    }

    @Override
    public RestResponse<List<BundleBaseSettingRespDto>> restCall(PullBundleDescriptionApi pullBundleDescriptionApi, BundleDescReqDto param) {
        return pullBundleDescriptionApi.basicList(param);
    }

    @Override
    public void preProcess(BundleDescDto<Map<String, BundleBaseSettingRespDto>> message, List<BundleBaseSettingRespDto> dataList) {
        if (this.appBundleService != null) {
            this.appBundleService.saveAppInfo(message);
            this.appBundleService.addModifyAppBundle(this.toAppBundleReqDtoList(message, dataList));
        }
    }

    private List<AppBundleReqDto> toAppBundleReqDtoList(BundleDescDto mqMsg, List<BundleBaseSettingRespDto> bundleList) {
        ArrayList appBundleReqDtoList = Lists.newArrayList();
        for (BundleBaseSettingRespDto bundleBaseSettingRespDto : bundleList) {
            if (StringUtils.isEmpty((CharSequence)bundleBaseSettingRespDto.getGroupId()) || StringUtils.isEmpty((CharSequence)bundleBaseSettingRespDto.getArtifactId()) || StringUtils.isEmpty((CharSequence)bundleBaseSettingRespDto.getVersion())) {
                logger.info("\u5f53\u524d\u529f\u80fd\u5305\u57fa\u672c\u4fe1\u606f[groupId:{}, artifactId:{}, version:{}]\u7f3a\u5931\uff0c\u8df3\u8fc7\u5b58\u50a8\u5e94\u7528\u548c\u529f\u80fd\u5305\u7684\u5173\u7cfb\uff01", new Object[]{bundleBaseSettingRespDto.getGroupId(), bundleBaseSettingRespDto.getArtifactId(), bundleBaseSettingRespDto.getVersion()});
                continue;
            }
            AppBundleReqDto appBundleReqDto = new AppBundleReqDto();
            appBundleReqDto.setCode(mqMsg.getServiceId());
            appBundleReqDto.setVersion(mqMsg.getApplicationVersion());
            appBundleReqDto.setBundleVersion(bundleBaseSettingRespDto.getVersion());
            String artifactId = bundleBaseSettingRespDto.getArtifactId();
            if (bundleBaseSettingRespDto.getArtifactId().startsWith("bundle")) {
                artifactId = bundleBaseSettingRespDto.getArtifactId().replaceFirst("bundle-", "");
            }
            appBundleReqDto.setBundleCode(bundleBaseSettingRespDto.getGroupId() + "_" + artifactId);
            appBundleReqDtoList.add(appBundleReqDto);
        }
        return appBundleReqDtoList;
    }
}

