/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.StarterBundleDas;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundlePostProcessService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleProcessService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleSyncService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractBundleSyncService<T extends BundleBaseDto>
implements IBundleSyncService<T> {
    protected static Logger logger = LoggerFactory.getLogger(AbstractBundleSyncService.class);
    @Resource
    protected StarterBundleDas starterBundleDas;
    @Resource
    protected ICacheService cacheService;
    protected IBundleProcessService<T> bundleProcessService;
    protected IBundlePostProcessService bundlePostProcessService;
    protected static final String REDISKEY = "bundles:";

    public AbstractBundleSyncService(IBundleProcessService<T> bundleProcessService, IBundlePostProcessService bundlePostProcessService) {
        this.bundleProcessService = bundleProcessService;
        this.bundlePostProcessService = bundlePostProcessService;
        if (this.bundlePostProcessService == null) {
            this.bundlePostProcessService = () -> {};
        }
    }

    @Override
    public IBundleProcessService<T> bundleProcessService() {
        return this.bundleProcessService;
    }

    @Override
    public IBundlePostProcessService bundlePostProcessService() {
        return this.bundlePostProcessService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handle(List<T> bundleDescList, BundleDataTypeEnum bundleDataType) {
        if (CollectionUtils.isEmpty(bundleDescList)) {
            return;
        }
        for (BundleBaseDto bundleDesc : bundleDescList) {
            if (StringUtils.isEmpty((CharSequence)bundleDesc.getGroupId()) || StringUtils.isEmpty((CharSequence)bundleDesc.getArtifactId()) || StringUtils.isEmpty((CharSequence)bundleDesc.getVersion())) {
                logger.info("\u5f53\u524d\u529f\u80fd\u5305\u57fa\u672c\u4fe1\u606f[groupId:{}, artifactId:{}, version:{}, type:{}]\u7f3a\u5931\uff0c\u8df3\u8fc7\u7269\u6599\u66f4\u65b0\uff01", new Object[]{bundleDesc.getGroupId(), bundleDesc.getArtifactId(), bundleDesc.getVersion(), bundleDataType.getDesc()});
                continue;
            }
            String bundleCode = AbstractBundleSyncService.getBundleCode(bundleDesc.getGroupId(), bundleDesc.getArtifactId());
            try {
                this.refreshBundleData(bundleDesc, bundleCode);
            }
            catch (Exception e) {
                logger.warn("\u5237\u65b0\u529f\u80fd\u5305\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BizException(e.getMessage());
            }
        }
        this.bundlePostProcessService.after();
    }

    public static String getBundleCode(String groupId, String artifactId) {
        return (groupId + "_" + artifactId).replace("bundle-", "");
    }
}

