/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.service.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleBaseRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleBaseSettingRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDescRespDto;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.BundleEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.StdBundleEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleDependencyUpdateService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleHistoryBackService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleTypeConvertService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.ISettingUpdateService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.impl.AbstractBundleSyncService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BundleBaseSettingSyncService
extends AbstractBundleSyncService<BundleBaseSettingRespDto> {
    @Autowired(required=false)
    protected IBundleHistoryBackService bundleHistoryService = new IBundleHistoryBackService(){

        public BundleEo convert(BundleEo bundleEo) {
            return bundleEo;
        }
    };
    @Autowired(required=false)
    protected IBundleTypeConvertService bundleTypeConvertService = new IBundleTypeConvertService<BundleEo>(){

        @Override
        public BundleEo convert(BundleEo bundleEo) {
            return bundleEo;
        }
    };
    @Autowired(required=false)
    protected ISettingUpdateService settingUpdateService = new ISettingUpdateService(){};
    @Autowired(required=false)
    IBundleDependencyUpdateService bundleDependencyService = new IBundleDependencyUpdateService(){};

    public BundleBaseSettingSyncService() {
        super(t -> {}, () -> {});
    }

    @Override
    public void refreshBundleData(BundleBaseSettingRespDto bundleDesc, String bundleCode) {
        BundleEo bundleEo = this.starterBundleDas.selectByCode(bundleCode);
        String dbVersion = null;
        if (bundleEo != null && StringUtils.isNotBlank((CharSequence)bundleEo.getVersion())) {
            BundleBaseRespDto bundle;
            if (StrUtil.isBlank((CharSequence)bundleEo.getName()) && StrUtil.isBlank((CharSequence)bundleEo.getParentCode())) {
                return;
            }
            if (!Objects.equals(bundleDesc.getVersion(), bundleEo.getVersion())) {
                this.bundleHistoryService.bundleBackUp(bundleDesc.getGroupId(), bundleDesc.getArtifactId(), bundleDesc.getVersion(), this.bundleHistoryService.convert(bundleEo));
            }
            if (null != (bundle = bundleDesc.getBase()) && CollectionUtils.isNotEmpty((Collection)bundle.getDependencies())) {
                this.bundleDependencyService.addOrUpdateBundleDependencies(bundle.getDependencies(), bundleCode, bundleDesc.getGroupId(), bundleDesc.getArtifactId(), bundleDesc.getVersion(), bundleEo.getVersion());
            }
            dbVersion = bundleEo.getVersion();
            bundleEo = this.getBundleEo((BundleBaseDto)bundleDesc, bundleEo, bundleDesc.getBase());
            this.starterBundleDas.updateSelective((BaseEo)bundleEo);
        } else {
            BundleEo newBundleEo = this.getBundleEo((BundleBaseDto)bundleDesc, null, bundleDesc.getBase());
            newBundleEo.setParentCode(newBundleEo.getParentCode().replaceFirst("bundle-", ""));
            if (StrUtil.isBlank((CharSequence)newBundleEo.getName()) && StrUtil.isBlank((CharSequence)newBundleEo.getParentCode())) {
                return;
            }
            if (bundleEo != null && StringUtils.isBlank((CharSequence)bundleEo.getVersion())) {
                newBundleEo.setId(bundleEo.getId());
                this.starterBundleDas.updateSelective((BaseEo)newBundleEo);
            } else {
                this.starterBundleDas.insert((BaseEo)newBundleEo);
            }
            BundleBaseRespDto bundle = bundleDesc.getBase();
            if (null != bundle && CollectionUtils.isNotEmpty((Collection)bundle.getDependencies())) {
                this.bundleDependencyService.addOrUpdateBundleDependencies(bundle.getDependencies(), bundleCode, bundleDesc.getGroupId(), bundleDesc.getArtifactId(), bundleDesc.getVersion(), null);
            }
        }
        BundleDescRespDto bundleDescRespDto = new BundleDescRespDto();
        BeanUtils.copyProperties((Object)bundleDesc, (Object)bundleDescRespDto);
        this.settingUpdateService.addOrUpdateSetting(bundleDescRespDto, bundleCode, dbVersion);
    }

    protected <BUNDLE extends BundleEo> BundleEo getBundleEo(BundleBaseDto bundleBaseDto, BundleEo bundleEo, BundleBaseRespDto base) {
        if (bundleEo == null) {
            bundleEo = new BundleEo();
        }
        CubeBeanUtils.copyProperties((Object)((Object)bundleEo), (Object)bundleBaseDto, (String[])new String[0]);
        bundleEo.setCode(BundleBaseSettingSyncService.getBundleCode(bundleEo.getGroupId(), bundleEo.getArtifactId()));
        if (base != null) {
            CubeBeanUtils.copyProperties((Object)((Object)bundleEo), (Object)base, (String[])new String[]{"dependency"});
            Object bundle = this.bundleTypeConvertService.type2flag(this.bundleTypeConvertService.convert(bundleEo), true);
            bundleEo.setFrontendFlag(((StdBundleEo)((Object)bundle)).getFrontendFlag());
            bundleEo.setBackendFlag(((StdBundleEo)((Object)bundle)).getBackendFlag());
            bundleEo.setCenterFlag(((StdBundleEo)((Object)bundle)).getCenterFlag());
            bundleEo.setReleaseTime(base.getCreateTime());
            bundleEo.setParentCode(base.getParentBundle().replace("bundle-", ""));
        } else {
            logger.info("bundle code:{} base info is empty!", (Object)bundleEo.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)bundleEo.getName())) {
            bundleEo.setName("");
            logger.info("bundle code:{} base name is empty!", (Object)bundleEo.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)bundleEo.getProvider())) {
            bundleEo.setProvider(bundleBaseDto.getGroupId());
        }
        if (StringUtils.isEmpty((CharSequence)bundleEo.getParentCode())) {
            bundleEo.setParentCode("");
        }
        if (bundleEo.getReleaseTime() == null) {
            bundleEo.setReleaseTime(new Date());
        }
        return bundleEo;
    }
}

