/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.service.impl;

import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDtoRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDtosRespDto;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.config.StarterBatchUpdateSizeConfig;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.StarterDtoAttributeDas;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.StarterDtoDas;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.DtoAttributeEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.DtoEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.StdDtoEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IDtoUpdateService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dtoUpdateService")
public class DtoUpdateServiceImpl
implements IDtoUpdateService {
    public static final String BEAN_NAME = "dtoUpdateService";
    @Resource
    private StarterBatchUpdateSizeConfig starterBatchUpdateSizeConfig;
    @Resource
    private StarterDtoDas starterDtoDas;
    @Resource
    private StarterDtoAttributeDas starterDtoAttributeDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateBundleDto(BundleDtosRespDto bundleDesc, String bundleCode, String dbBundleVersion) {
        List bundleDtoList = bundleDesc.getDtos();
        List<DtoEo> dbDtoEoList = this.starterDtoDas.select(bundleCode);
        String version = bundleDesc.getVersion();
        if (dbBundleVersion != null && !dbBundleVersion.equals(version) && CollectionUtils.isNotEmpty(dbDtoEoList)) {
            this.backupDtoAndAttribute(bundleCode, version, dbDtoEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)bundleDtoList)) {
            Map<String, DtoEo> dbDtoMap = new HashMap<String, DtoEo>(dbDtoEoList.size());
            if (CollectionUtils.isNotEmpty(dbDtoEoList)) {
                dbDtoMap = dbDtoEoList.stream().collect(Collectors.toMap(StdDtoEo::getCode, Function.identity(), (k1, k2) -> k1));
            }
            List<DtoEo> dtoEoList = this.getDtoEoList(dbDtoMap, bundleDtoList, (BundleBaseDto)bundleDesc, bundleCode);
            List<DtoEo> toUpdateDtoEoList = dtoEoList.stream().filter(t -> t.getId() != null).collect(Collectors.toList());
            this.starterDtoDas.insertBatch(dtoEoList.stream().filter(t -> t.getId() == null).collect(Collectors.toList()));
            this.starterDtoDas.batchUpdateInJoin(this.starterBatchUpdateSizeConfig.readCount("bd_dto"), toUpdateDtoEoList);
            this.deleteOldAttributeBatch(toUpdateDtoEoList);
            Map<String, Long> dtoCode2DtoId = dtoEoList.stream().collect(Collectors.toMap(StdDtoEo::getCode, BaseEo::getId, (k1, k2) -> k1));
            this.insertAllAttributeBatch(bundleDtoList, dtoCode2DtoId);
        }
    }

    private List<DtoEo> getDtoEoList(Map<String, DtoEo> dbDtoEoMap, List<BundleDtoRespDto> bundleDtoList, BundleBaseDto bundleBaseDto, String bundleCode) {
        ArrayList dtoEoList = Lists.newArrayList();
        for (BundleDtoRespDto bundleDtoRespDto : bundleDtoList) {
            DtoEo dtoEo = dbDtoEoMap.get(bundleDtoRespDto.getCode());
            if (dtoEo == null) {
                dtoEo = new DtoEo();
            }
            this.dto2Eo(bundleBaseDto, bundleDtoRespDto, bundleCode, dtoEo);
            String name = dtoEo.getName();
            if (name != null && name.length() > 20) {
                dtoEo.setName(name.substring(0, 17) + "...");
            }
            dtoEoList.add(dtoEo);
        }
        return dtoEoList;
    }

    private void dto2Eo(BundleBaseDto bundleBaseDto, BundleDtoRespDto bundleDtoRespDto, String bundleCode, DtoEo dtoEo) {
        BeanUtils.copyProperties((Object)bundleDtoRespDto, (Object)((Object)dtoEo), (String[])new String[]{"attributes"});
        dtoEo.setBundleGroupId(bundleBaseDto.getGroupId());
        dtoEo.setBundleArtifactId(bundleBaseDto.getArtifactId());
        dtoEo.setBundleCode(bundleCode);
        dtoEo.setBundleVersion(bundleBaseDto.getVersion());
        if (StringUtils.isEmpty((CharSequence)dtoEo.getExtension())) {
            dtoEo.setExtension("");
        }
        dtoEo.setUpdateTime(new Date());
    }

    private void attributeDto2Eo(List<DtoAttributeEo> dtoAttributeEoList, List<BundleDtoRespDto.DtoAttribute> attrList, Long dtoId) {
        for (BundleDtoRespDto.DtoAttribute attr : attrList) {
            String name;
            DtoAttributeEo dtoAttributeEo = new DtoAttributeEo();
            BeanUtils.copyProperties((Object)attr, (Object)((Object)dtoAttributeEo));
            dtoAttributeEo.setDtoId(dtoId);
            if (StringUtils.isEmpty((CharSequence)dtoAttributeEo.getExtension())) {
                dtoAttributeEo.setExtension("");
            }
            if ((name = dtoAttributeEo.getName()) != null && name.length() > 20) {
                dtoAttributeEo.setName(name.substring(0, 17) + "...");
            }
            dtoAttributeEoList.add(dtoAttributeEo);
        }
    }

    private void insertAllAttributeBatch(List<BundleDtoRespDto> bundleDtoRespDtoList, Map<String, Long> dtoCode2DtoId) {
        ArrayList dtoAttributeEoList = Lists.newArrayList();
        for (BundleDtoRespDto bundleDtoRespDto : bundleDtoRespDtoList) {
            List attrList = bundleDtoRespDto.getAttributes();
            Long dtoId = dtoCode2DtoId.get(bundleDtoRespDto.getCode());
            if (!CollectionUtils.isNotEmpty((Collection)attrList)) continue;
            this.attributeDto2Eo(dtoAttributeEoList, attrList, dtoId);
        }
        this.starterDtoAttributeDas.insertBatch(dtoAttributeEoList);
    }

    private void deleteOldAttributeBatch(List<DtoEo> dtoEoList) {
        if (CollectionUtils.isEmpty(dtoEoList)) {
            return;
        }
        List dtoIds = dtoEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlfilters = new ArrayList<SqlFilter>();
        sqlfilters.add(SqlFilter.in((String)"dto_id", (Object)StringUtils.join(dtoIds, (String)",")));
        DtoAttributeEo dtoAttributeEo = new DtoAttributeEo();
        dtoAttributeEo.setSqlFilters(sqlfilters);
        List deleteEos = this.starterDtoAttributeDas.select((BaseEo)dtoAttributeEo, 1, 10000);
        if (CollectionUtils.isNotEmpty((Collection)deleteEos)) {
            this.starterDtoAttributeDas.logicDeleteBatch((Long[])deleteEos.stream().map(BaseEo::getId).toArray(Long[]::new));
        }
    }
}

