/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.starter.bundle.dto.BundleDataUploadDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.config.BundleBootMqConsumerConfig;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.constants.Constants;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.StarterAppStartedDataTypeDas;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.StarterAppStartedRecordDas;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.dto.AppStartedRecordReqDto;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.enums.AppStartedPullStatus;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.AppStartedDataTypeEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.AppStartedRecordEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IStarterAppStartedRecordService;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.util.SqlFilterBuilder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="starterAppStartedRecordService")
public class StarterAppStartedRecordServiceImpl
implements IStarterAppStartedRecordService {
    public static final String BEAN_NAME = "starterAppStartedRecordService";
    private Logger logger = LoggerFactory.getLogger(StarterAppStartedRecordServiceImpl.class);
    @Resource
    private StarterAppStartedRecordDas starterAppStartedRecordDas;
    @Resource
    private StarterAppStartedDataTypeDas starterAppStartedDataTypeDas;
    @Resource
    private BundleBootMqConsumerConfig bundleBootMqConsumerConfig;

    @Override
    public Long addAppStartedRecord(AppStartedRecordReqDto addReqDto) {
        if (addReqDto.getCode() == null) {
            return -1L;
        }
        AppStartedRecordEo appStartedRecordSelect = this.toAppStartedRecordSelect(addReqDto);
        AppStartedRecordEo exists = (AppStartedRecordEo)this.starterAppStartedRecordDas.selectOne((BaseEo)appStartedRecordSelect);
        if (exists == null) {
            exists = new AppStartedRecordEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)exists);
            exists.setStatus(AppStartedPullStatus.DOING.name());
            this.starterAppStartedRecordDas.insert((BaseEo)exists);
        }
        AppStartedDataTypeEo appStartedDataTypeSelect = new AppStartedDataTypeEo();
        appStartedDataTypeSelect.setAppStartedRecordId(exists.getId());
        appStartedDataTypeSelect.setType(addReqDto.getType());
        AppStartedDataTypeEo appStartedDataTypeEo = (AppStartedDataTypeEo)this.starterAppStartedDataTypeDas.selectOne((BaseEo)appStartedDataTypeSelect);
        if (null == appStartedDataTypeEo) {
            appStartedDataTypeEo = new AppStartedDataTypeEo();
            appStartedDataTypeEo.setAppStartedRecordId(exists.getId());
            appStartedDataTypeEo.setType(addReqDto.getType());
            appStartedDataTypeEo.setStatus(AppStartedPullStatus.DOING.name());
            this.starterAppStartedDataTypeDas.insert((BaseEo)appStartedDataTypeEo);
        }
        return exists.getId();
    }

    @Override
    public void modifyStatusById(Long id, int dataType, String status, BundleDataUploadDto bundleDataUploadDto) {
        AppStartedDataTypeEo appStartedDataTypeEo = new AppStartedDataTypeEo();
        appStartedDataTypeEo.setSqlFilters(SqlFilterBuilder.newInstance().buildEqualsSqlFilter("app_started_record_id", id).buildEqualsSqlFilter("type", dataType).get());
        appStartedDataTypeEo.setStatus(status);
        this.starterAppStartedDataTypeDas.updateSelectiveSqlFilter((BaseEo)appStartedDataTypeEo);
        if (AppStartedPullStatus.DONE.name().equals(status)) {
            AppStartedDataTypeEo appStartedDataTypeSelect = new AppStartedDataTypeEo();
            appStartedDataTypeSelect.setAppStartedRecordId(id);
            List dataTypeList = this.starterAppStartedDataTypeDas.select((BaseEo)appStartedDataTypeSelect);
            if (CollectionUtils.isNotEmpty((Collection)dataTypeList)) {
                int[] dones = new int[BundleDataTypeEnum.values().length];
                for (AppStartedDataTypeEo appStartedDataTypeEo2 : dataTypeList) {
                    dones[appStartedDataTypeEo2.getType().intValue() - 1] = Constants.ENABLE;
                }
                if (null != bundleDataUploadDto) {
                    if (!bundleDataUploadDto.isDto()) {
                        dones[BundleDataTypeEnum.DTO.getKey() - 1] = 1;
                    }
                    if (!bundleDataUploadDto.isFlow()) {
                        dones[BundleDataTypeEnum.FLOW.getKey() - 1] = 1;
                    }
                    if (!bundleDataUploadDto.isBaseSetting()) {
                        dones[BundleDataTypeEnum.BASE_SETTING.getKey() - 1] = 1;
                    }
                    if (!bundleDataUploadDto.isApi()) {
                        dones[BundleDataTypeEnum.API.getKey() - 1] = 1;
                    }
                }
                boolean finalDone = true;
                for (int done : dones) {
                    if (done == 1) continue;
                    finalDone = false;
                    break;
                }
                if (finalDone) {
                    AppStartedRecordEo appStartedRecordEo = new AppStartedRecordEo();
                    appStartedRecordEo.setId(id);
                    appStartedRecordEo.setStatus(AppStartedPullStatus.DONE.name());
                    this.starterAppStartedRecordDas.updateSelective((BaseEo)appStartedRecordEo);
                }
            }
        } else {
            this.logger.info("set app start record status to fail :{}", (Object)id);
            AppStartedRecordEo eo = new AppStartedRecordEo();
            eo.setId(id);
            eo.setStatus(status);
            this.starterAppStartedRecordDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public boolean existsFinishedDataType(Date packageTime, String version, String code, int type) {
        if (StringUtils.isBlank((CharSequence)code)) {
            this.logger.info("\u529f\u80fd\u5305\u7f16\u7801\u4e3a\u7a7a\uff0c\u76f4\u63a5\u5224\u5b9a\u4e3a\u4e0d\u5b58\u5728{}\u6570\u636e\u7c7b\u578b\u7684\u5904\u7406\u8bb0\u5f55", (Object)type);
            return false;
        }
        AppStartedRecordEo queryEo = new AppStartedRecordEo();
        queryEo.setCode(code);
        queryEo.setPackageTime(packageTime);
        queryEo.setVersion(version);
        queryEo.setStatus(AppStartedPullStatus.DONE.name());
        List doneList = this.starterAppStartedRecordDas.select((BaseEo)queryEo, 1, 1);
        if (CollectionUtils.isNotEmpty((Collection)doneList)) {
            this.logger.info("\u5f53\u524d\u7248\u672c+\u6253\u5305\u65f6\u95f4\u7684\u5e94\u7528\u529f\u80fd\u5305\u542f\u52a8\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728");
            return true;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.ne((String)"status", (Object)AppStartedPullStatus.DONE.name()));
        queryEo.setSqlFilters(sqlFilters);
        queryEo.setStatus(null);
        List undoneList = this.starterAppStartedRecordDas.select((BaseEo)queryEo, 1, 1000);
        if (CollectionUtils.isEmpty((Collection)undoneList)) {
            this.logger.info("\u4e0d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u542f\u52a8\u8bb0\u5f55\uff0c\u5219\u8868\u660e\u672a\u6709\u4efb\u4f55\u7684\u6570\u636e\u7c7b\u578b\u5904\u7406");
            return false;
        }
        List idList = undoneList.stream().map(BaseEo::getId).collect(Collectors.toList());
        AppStartedDataTypeEo appStartedDataTypeSelect = new AppStartedDataTypeEo();
        appStartedDataTypeSelect.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("app_started_record_id", idList).get());
        appStartedDataTypeSelect.setType(type);
        appStartedDataTypeSelect.setStatus(AppStartedPullStatus.DONE.name());
        List dataTypeEoList = this.starterAppStartedDataTypeDas.select((BaseEo)appStartedDataTypeSelect, 1, 1);
        return CollectionUtils.isNotEmpty((Collection)dataTypeEoList);
    }

    @Override
    public AppStartedRecordEo findAppStartRecord(AppStartedRecordReqDto appStartedRecordReqDto) {
        AppStartedRecordEo appStartedRecordQuery = this.toAppStartedRecordSelect(appStartedRecordReqDto);
        return (AppStartedRecordEo)this.starterAppStartedRecordDas.selectOne((BaseEo)appStartedRecordQuery);
    }

    private AppStartedRecordEo toAppStartedRecordSelect(AppStartedRecordReqDto appStartedRecordReqDto) {
        AppStartedRecordEo appStartedRecordQuery = new AppStartedRecordEo();
        appStartedRecordQuery.setCode(appStartedRecordReqDto.getCode());
        appStartedRecordQuery.setIp(appStartedRecordReqDto.getIp());
        appStartedRecordQuery.setPackageTime(appStartedRecordReqDto.getPackageTime());
        appStartedRecordQuery.setPort(appStartedRecordReqDto.getPort());
        appStartedRecordQuery.setVersion(appStartedRecordReqDto.getVersion());
        appStartedRecordQuery.setBootTime(appStartedRecordReqDto.getBootTime());
        return appStartedRecordQuery;
    }
}

