/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.materiel.consumer.util;

import com.dtyunxi.eo.SqlFilter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SqlFilterBuilder {
    private final List<SqlFilter> filters = new LinkedList<SqlFilter>();

    private SqlFilterBuilder() {
    }

    public SqlFilterBuilder buildInSqlFilter(String key, Collection<?> data) {
        this.filters.add(SqlFilter.in((String)key, data));
        return this;
    }

    public SqlFilterBuilder buildEqualsSqlFilter(String key, Object value) {
        this.filters.add(SqlFilter.eq((String)key, (Object)value));
        return this;
    }

    public SqlFilterBuilder buildBetweenSqlFilter(String key, Object start, Object end) {
        if (null != start) {
            this.filters.add(SqlFilter.gt((String)key, (Object)start));
        }
        if (null != end) {
            this.filters.add(SqlFilter.lt((String)key, (Object)end));
        }
        return this;
    }

    public List<SqlFilter> get() {
        return this.filters;
    }

    public static SqlFilterBuilder newInstance() {
        return new SqlFilterBuilder();
    }

    public SqlFilterBuilder buildBetweenSqlFilter2(String key, Object start, Object end) {
        if (null != start) {
            this.get().add(SqlFilter.ge((String)key, (Object)start));
        }
        if (null != end) {
            this.get().add(SqlFilter.le((String)key, (Object)end));
        }
        return this;
    }

    public SqlFilterBuilder buildTimeBetweenSqlFilter(String key, String start, String end) {
        if (null != start) {
            this.get().add(SqlFilter.ge((String)key, (Object)(start.length() == 10 ? start + " 00:00:00" : start)));
        }
        if (null != end) {
            this.get().add(SqlFilter.le((String)key, (Object)(end.length() == 10 ? end + " 23:59:59" : end)));
        }
        return this;
    }

    public static <PARAM> SqlFilter buildFuzzyParam(PARAM param, String property) {
        SqlFilter filter = new SqlFilter();
        filter.setProperty(property);
        filter.setOperator(SqlFilter.Operator.like);
        filter.setValue((Object)new StringBuilder("%").append(param).append("%"));
        return filter;
    }

    public static <PARAM> SqlFilter buildInParam(PARAM param, String property) {
        SqlFilter filter = new SqlFilter();
        filter.setProperty(property);
        filter.setOperator(SqlFilter.Operator.in);
        filter.setValue(param);
        return filter;
    }

    public static SqlFilterBuilder buildNotEqualsSqlFilter(String key, Object value) {
        SqlFilterBuilder sqlFilterBuilder = SqlFilterBuilder.newInstance();
        sqlFilterBuilder.get().add(SqlFilter.ne((String)key, (Object)value));
        return sqlFilterBuilder;
    }
}

