CREATE TABLE `fn_bundle` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200) NOT NULL COMMENT '全局唯一，推荐使用maven的groupId+artifactId',
  `name` varchar(64) NOT NULL COMMENT '功能包名称，全局唯一',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态：0 禁用 1启用',
  `frontend_flag` tinyint(1) NOT NULL DEFAULT '0' COMMENT '前端应用标志，0不是前端应用，1是前端应用，默认值0',
  `backend_flag` tinyint(1) NOT NULL DEFAULT '0' COMMENT '后端应用标志，0不是后端应用，1是后端应用，默认值0',
  `center_flag` tinyint(1) NOT NULL DEFAULT '0' COMMENT '能力中心标志，0不是能力中心，1是能力中心，默认值0',
  `provider` varchar(64) NOT NULL COMMENT '功能包提供者',
  `parent_code` varchar(200) NOT NULL COMMENT '父功能包代码，一级功能包填写ROOT_NODE',
  `descr` varchar(200) DEFAULT NULL COMMENT '简介',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `group_id` varchar(64) DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64) DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64) DEFAULT NULL COMMENT '版本号',
  `module` varchar(64) DEFAULT NULL COMMENT '所属模块',
  `application` varchar(64) DEFAULT NULL COMMENT '所属应用',
  `release_time` datetime DEFAULT NULL COMMENT '发布时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_code_version` (`code`,`version`),
  KEY `idx_code` (`code`) USING BTREE,
  KEY `idx_parent_code` (`parent_code`) USING BTREE,
  KEY `idx_groupId_artifactId_version` (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='功能包信息';

CREATE TABLE `fn_app_started_data_type` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `app_started_record_id` bigint(20) NOT NULL COMMENT 'fn_app_started_record表主键',
  `type` int(4) NOT NULL COMMENT '类型[1:base 2:api 3:dto 4:flow]用于处理功能包上报的数据类型是否已处理',
  `status` varchar(16) DEFAULT NULL COMMENT '应用启动时物料拉取的处理状态，DOING/FAILED/DONE',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户ID',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='应用启动上报数据类型表，用于处理功能包上报的数据类型是否已处理';

CREATE TABLE `fn_app_started_record` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(64) NOT NULL COMMENT '应用编码，例如yundt-cube-center-user',
  `version` varchar(64) DEFAULT NULL COMMENT '应用Maven版本号，例如3.0.7.0-CUBE-SNAPSHOT',
  `boot_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '应用启动时间',
  `package_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '应用Maven打包时间',
  `ip` varchar(64) NOT NULL COMMENT '应用部署的IP地址，例如192.168.33.12',
  `port` int(11) NOT NULL COMMENT '应用部署的端口号，例如18090',
  `status` varchar(16) NOT NULL COMMENT '应用启动时物料拉取的处理状态，DOING/FAILED/DONE',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户ID',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='应用启动记录表';

CREATE TABLE `fn_dto` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(128) DEFAULT NULL COMMENT 'DTO编码',
  `name` varchar(128) DEFAULT NULL COMMENT 'DTO名称',
  `descr` varchar(1024) DEFAULT NULL COMMENT 'DTO描述',
  `domain` varchar(32) DEFAULT NULL COMMENT '领域编码',
  `bundle_code` varchar(256) DEFAULT NULL COMMENT '功能包编码',
  `group_id` varchar(64) DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64) DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64) DEFAULT NULL COMMENT '功能包版本号',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户ID',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`),
  KEY `idx_code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='DTO';

CREATE TABLE `fn_dto_attribute` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `dto_id` bigint(20) DEFAULT NULL COMMENT '所属DTO',
  `code` varchar(128) DEFAULT NULL COMMENT '属性编码',
  `name` varchar(256) DEFAULT NULL COMMENT '属性名称',
  `data_type` varchar(512) DEFAULT NULL COMMENT '数据类型',
  `length` int(11) DEFAULT NULL COMMENT '数据长度',
  `is_nullable` int(11) DEFAULT '1' COMMENT '是否允许为空（0=否 1=是）',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户ID',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`),
  KEY `idx_dto_id` (`dto_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='功能包DTO属性';