/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.starter.bundle.common.IChartHurdleLoader;
import com.dtyunxi.cube.starter.bundle.config.BundleReportModeConfig;
import com.dtyunxi.cube.starter.bundle.config.CubeBundleDataUploadConfig;
import com.dtyunxi.cube.starter.bundle.config.ExtraBundleLoadedConfig;
import com.dtyunxi.cube.starter.bundle.config.FeignClientConfig;
import com.dtyunxi.cube.starter.bundle.fallback.MqBootFeignFallbackFactory;
import com.dtyunxi.cube.starter.bundle.runner.ApiEnhanceSenderRunner;
import com.dtyunxi.cube.starter.bundle.runner.BocSenderRunner;
import com.dtyunxi.cube.starter.bundle.runner.BundleMqSenderRunner;
import com.dtyunxi.cube.starter.bundle.service.BundleApiEnhanceService;
import com.dtyunxi.cube.starter.bundle.service.IPullBundleService;
import com.dtyunxi.cube.starter.bundle.service.PullChartAndHurdleService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FeignClientConfig.class})
public class CubeBundleAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="bundle.report.mode")
    public BundleReportModeConfig bundleReportModeConfig() {
        return new BundleReportModeConfig();
    }

    @Bean
    @ConfigurationProperties(prefix="bundle.data.upload")
    public CubeBundleDataUploadConfig cubeBundleDataUploadConfig() {
        return new CubeBundleDataUploadConfig();
    }

    @Bean
    @ConfigurationProperties(prefix="bundle.data.extra")
    public ExtraBundleLoadedConfig extraBundleLoadedConfig() {
        return new ExtraBundleLoadedConfig();
    }

    @Bean
    @ConditionalOnProperty(value={"bundle.boot.notity"}, havingValue="true", matchIfMissing=true)
    public BundleMqSenderRunner bundleMqSenderRunner(ICommonsMqService commonsMqService, ExtraBundleLoadedConfig extraBundleLoadedConfig, CubeBundleDataUploadConfig cubeBundleDataUploadConfig, @Value(value="${server.port:8080}") int port, @Value(value="${dtyunxi.env.module}") String serviceId, @Value(value="${dtyunxi.env.module-name:}") String serviceName, BundleReportModeConfig bundleReportModeConfig) {
        return new BundleMqSenderRunner(extraBundleLoadedConfig, cubeBundleDataUploadConfig, commonsMqService, port, serviceId, serviceName, bundleReportModeConfig);
    }

    @Bean
    @ConditionalOnBean(value={IChartHurdleLoader.class})
    public BocSenderRunner bocSenderRunner(ICommonsMqService commonsMqService, @Value(value="${server.port:8080}") int port, @Value(value="${dtyunxi.env.module}") String serviceId, PullChartAndHurdleService pullChartAndHurdleService) {
        return new BocSenderRunner(commonsMqService, port, serviceId, pullChartAndHurdleService);
    }

    @Bean
    public BundleApiEnhanceService bundleApiEnhanceService() {
        return new BundleApiEnhanceService();
    }

    @Bean
    public ApiEnhanceSenderRunner apiEnhanceSenderRunner(@Value(value="${dtyunxi.yundt.cube.bundle.reportApiInfoAtStartup:true}") boolean notity) {
        return new ApiEnhanceSenderRunner(notity);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="cube.starter.bundle.defaultPullBundleService", name={"enabled"}, matchIfMissing=true)
    public IPullBundleService pullBundleService() {
        return optionQueryReqDto -> new HashMap();
    }

    @Bean
    public PullChartAndHurdleService pullChartAndHurdleService() {
        return new PullChartAndHurdleService();
    }

    @Bean
    @ConditionalOnMissingBean(value={MqBootFeignFallbackFactory.class})
    public MqBootFeignFallbackFactory mqBootFeignFallbackFactory() {
        return new MqBootFeignFallbackFactory();
    }
}

