/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.runner;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.starter.bundle.annotate.CubeWeakDependency;
import com.dtyunxi.cube.starter.bundle.config.WeakReferenceBeanPostProcessor;
import com.dtyunxi.cube.starter.bundle.dto.WeakReferenceDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleApiRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleApisRespDto;
import com.dtyunxi.cube.starter.bundle.reader.BundleApiReader;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.AppBundleReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BundleLoadedQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AppBundleRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BundleLoadedRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IWeakReferenceQueryApi;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BundleLoadedInjectRunner
implements CommandLineRunner,
BeanFactoryAware,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(BundleLoadedInjectRunner.class);
    private static final Map<Object, WeakReferenceDto.WeakReferenceFieldDto> proxy2WeakField = new ConcurrentHashMap<Object, WeakReferenceDto.WeakReferenceFieldDto>();
    private static final Map<String, Object> api2Proxy = new ConcurrentHashMap<String, Object>();
    private BeanFactory beanFactory;
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private IWeakReferenceQueryApi weakReferenceQueryApi;
    @Value(value="${bundle.dependencies:}")
    private String dependencies;

    public void run(String ... args) throws Exception {
        Map<Class<?>, WeakReferenceDto> map = WeakReferenceBeanPostProcessor.getBean2Api();
        if (MapUtils.isEmpty(map)) {
            return;
        }
        Map<String, String> bundleMap = this.completeBundleInfo();
        this.pullBundleLoadedInfo(bundleMap);
        Set<Map.Entry<Class<?>, WeakReferenceDto>> set = map.entrySet();
        Iterator<Map.Entry<Class<?>, WeakReferenceDto>> it = set.iterator();
        WeakReferenceDto value = null;
        while (it.hasNext()) {
            Map.Entry<Class<?>, WeakReferenceDto> entry = it.next();
            Class<?> key = entry.getKey();
            value = entry.getValue();
            logger.info(key.getCanonicalName() + ", " + JSON.toJSONString((Object)value));
            if (CollectionUtils.isEmpty(value.getWeakReferenceFieldDtos())) continue;
            for (WeakReferenceDto.WeakReferenceFieldDto weakReferenceFieldDto : value.getWeakReferenceFieldDtos()) {
                if (weakReferenceFieldDto.getBundleLoaded().booleanValue()) continue;
                Object proxy = this.injectWeakReference(value.getBeanClass(), value.getTarget(), weakReferenceFieldDto.getField(), weakReferenceFieldDto.getFieldClazz(), weakReferenceFieldDto);
                weakReferenceFieldDto.setFieldDeveloperProxy(proxy);
            }
        }
    }

    private void pullBundleLoadedInfo(Map<String, String> bundleMap) {
        if (MapUtils.isEmpty(bundleMap)) {
            return;
        }
        BundleLoadedQueryReqDto bundleLoadedQueryReqDto = new BundleLoadedQueryReqDto();
        ArrayList appBundleReqDtoList = new ArrayList();
        bundleMap.forEach((key, value) -> {
            AppBundleReqDto appBundleReqDto = new AppBundleReqDto();
            appBundleReqDto.setBundleCode(key);
            appBundleReqDto.setBundleVersion(value);
            appBundleReqDtoList.add(appBundleReqDto);
        });
        bundleLoadedQueryReqDto.setAppBundleReqDtoList(appBundleReqDtoList);
        try {
            RestResponse resp = this.weakReferenceQueryApi.queryBundleLoadedInfo(bundleLoadedQueryReqDto);
            if ("0".equals(resp.getResultCode()) && null != resp.getData()) {
                List bundleList = ((BundleLoadedRespDto)resp.getData()).getBundleList();
                Map<String, List<String>> bundle2Api = WeakReferenceBeanPostProcessor.getBundle2Api();
                Map<String, List<Class<?>>> api2Bean = WeakReferenceBeanPostProcessor.getApi2Bean();
                Map<Class<?>, WeakReferenceDto> bean2Api = WeakReferenceBeanPostProcessor.getBean2Api();
                for (AppBundleRespDto appBundleRespDto : bundleList) {
                    if (!bundle2Api.containsKey(appBundleRespDto.getBundleCode())) continue;
                    List<String> apis = bundle2Api.get(appBundleRespDto.getBundleCode());
                    for (String api : apis) {
                        List<Class<?>> beanClassList = api2Bean.get(api);
                        if (CollectionUtils.isEmpty(beanClassList)) continue;
                        for (Class<?> beanClass : beanClassList) {
                            WeakReferenceDto.WeakReferenceFieldDto weakFieldDto = WeakReferenceBeanPostProcessor.getWeakReferenceFieldDto(api, beanClass);
                            if (null == weakFieldDto) continue;
                            weakFieldDto.setBundleLoaded(true);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u529f\u80fd\u5305\u52a0\u8f7d\u4fe1\u606f\u51fa\u9519\uff0cbundleLoadedQueryReqDto\uff1a{}", (Object)JSON.toJSONString((Object)bundleLoadedQueryReqDto), (Object)e);
        }
    }

    public void modifyBeanDefinition(Class<?> beanClass, WeakReferenceDto.WeakReferenceFieldDto fieldDto) {
        WeakReferenceDto dto = WeakReferenceBeanPostProcessor.getBean2Api().get(beanClass);
        Field field = fieldDto.getField();
        try {
            ReflectionUtils.makeAccessible((Field)field);
            if (fieldDto.getBundleLoaded().booleanValue()) {
                field.set(dto.getTarget(), fieldDto.getFieldSystemProxy());
            } else {
                if (null == fieldDto.getFieldDeveloperProxy()) {
                    Object proxy = this.injectWeakReference(dto.getBeanClass(), dto.getTarget(), fieldDto.getField(), fieldDto.getFieldClazz(), fieldDto);
                    fieldDto.setFieldDeveloperProxy(proxy);
                }
                field.set(dto.getTarget(), fieldDto.getFieldDeveloperProxy());
            }
        }
        catch (IllegalAccessException e) {
            logger.warn("\u6ce8\u5165{}\u7684{}\u5b57\u6bb5\u5931\u8d25:{}", new Object[]{dto.getBeanClass().getCanonicalName(), field.getName(), e.getMessage()});
        }
    }

    private Map<String, String> completeBundleInfo() {
        HashMap<String, String> bundleMap = new HashMap<String, String>();
        Map<String, List<String>> bundle2Api = WeakReferenceBeanPostProcessor.getBundle2Api();
        Map<Class<?>, WeakReferenceDto> bean2Api = WeakReferenceBeanPostProcessor.getBean2Api();
        Map<String, List<Class<?>>> api2Bean = WeakReferenceBeanPostProcessor.getApi2Bean();
        HashMap artifactMap = Maps.newHashMap();
        new BundleApiReader().process(Boolean.valueOf(true));
        ArrayList bundleApisList = new ArrayList(artifactMap.values());
        for (BundleApisRespDto bundleApisRespDto : bundleApisList) {
            if (CollectionUtils.isEmpty((Collection)bundleApisRespDto.getApis())) continue;
            String bundleCode = this.generateBundleCode(bundleApisRespDto.getGroupId(), bundleApisRespDto.getArtifactId());
            for (BundleApiRespDto api : bundleApisRespDto.getApis()) {
                List<Class<?>> beanClassList;
                if (StringUtils.isEmpty((Object)api.getGroupCode()) || CollectionUtils.isEmpty(beanClassList = api2Bean.get(api.getGroupCode()))) continue;
                for (Class<?> beanClass : beanClassList) {
                    WeakReferenceDto.WeakReferenceFieldDto weakFieldDto;
                    WeakReferenceDto weakReferenceDto = bean2Api.get(beanClass);
                    if (null == weakReferenceDto || null == (weakFieldDto = (WeakReferenceDto.WeakReferenceFieldDto)weakReferenceDto.getWeakReferenceFieldDtos().stream().filter(fieldDto -> fieldDto.getFieldClazz().getCanonicalName().equals(api.getGroupCode())).findFirst().orElse(null))) continue;
                    weakFieldDto.setBundleCode(bundleCode);
                    weakFieldDto.setBundleVersion(bundleApisRespDto.getVersion());
                    if (this.isAppContainBundle(bundleCode).booleanValue()) {
                        weakFieldDto.setBundleLoaded(true);
                        weakFieldDto.setAppBundle(true);
                        continue;
                    }
                    weakFieldDto.setBundleLoaded(false);
                    weakFieldDto.setAppBundle(false);
                    bundleMap.put(bundleCode, bundleApisRespDto.getVersion());
                }
                List<String> apiList = bundle2Api.get(bundleCode);
                if (null == apiList) {
                    apiList = new ArrayList<String>();
                    apiList.add(api.getGroupCode());
                    bundle2Api.put(bundleCode, apiList);
                    continue;
                }
                apiList.add(api.getGroupCode());
            }
        }
        return bundleMap;
    }

    private String generateBundleCode(String groupId, String artifactId) {
        return groupId + "_" + artifactId.replaceFirst("bundle-", "");
    }

    private Object injectWeakReference(Class<?> beanClass, Object target, Field field, Class<?> fieldClazz, WeakReferenceDto.WeakReferenceFieldDto weakReferenceFieldDto) {
        Object proxy = api2Proxy.get(fieldClazz.getCanonicalName());
        CubeWeakDependency weakDependency = field.getAnnotation(CubeWeakDependency.class);
        if (null == proxy) {
            if (Object.class.equals(weakDependency.value())) {
                proxy = Proxy.newProxyInstance(fieldClazz.getClassLoader(), new Class[]{fieldClazz}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return null;
                    }
                });
                api2Proxy.put(fieldClazz.getCanonicalName(), proxy);
            } else {
                proxy = Proxy.newProxyInstance(fieldClazz.getClassLoader(), new Class[]{fieldClazz}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (Object.class.equals(method.getDeclaringClass())) {
                            return method.invoke((Object)this, args);
                        }
                        ArrayList argClassList = new ArrayList();
                        for (Object arg : args) {
                            argClassList.add(arg.getClass());
                        }
                        WeakReferenceDto.WeakReferenceFieldDto weakField = BundleLoadedInjectRunner.getProxy2WeakField().get(proxy);
                        if (weakField.getBundleLoaded().booleanValue()) {
                            method.invoke(weakField.getFieldSystemProxy(), argClassList);
                        }
                        CubeWeakDependency cubeWeakDependency = weakField.getField().getAnnotation(CubeWeakDependency.class);
                        Class<?> clazz = cubeWeakDependency.value();
                        Object defaultService = null;
                        try {
                            defaultService = BundleLoadedInjectRunner.this.beanFactory.getBean(clazz);
                        }
                        catch (NoSuchBeanDefinitionException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            logger.error("BeanFactory.getBean()\u83b7\u53d6bean\u5931\u8d25\uff0cclazz\uff1a" + clazz.getCanonicalName(), (Throwable)e);
                            return null;
                        }
                        try {
                            Method realMethod = clazz.getDeclaredMethod(method.getName(), argClassList.toArray(new Class[args.length]));
                            return realMethod.invoke(defaultService, args);
                        }
                        catch (NoSuchMethodException e) {
                            return null;
                        }
                        catch (Exception e) {
                            logger.error("\u83b7\u53d6interface\u65b9\u6cd5\u5931\u8d25\uff0cclazz\uff1a{}\uff0cmethod\uff1a{}", new Object[]{clazz.getCanonicalName(), method.getName(), e});
                            return null;
                        }
                    }
                });
                api2Proxy.put(fieldClazz.getCanonicalName(), proxy);
            }
        }
        try {
            ReflectionUtils.makeAccessible((Field)field);
            field.set(target, proxy);
            proxy2WeakField.put(proxy, weakReferenceFieldDto);
        }
        catch (IllegalAccessException e) {
            logger.warn("\u6ce8\u5165{}\u7684{}\u5b57\u6bb5\u5931\u8d25:{}", new Object[]{beanClass.getCanonicalName(), field.getName(), e.getMessage()});
        }
        return proxy;
    }

    private Boolean isAppContainBundle(String bundleCode) {
        if (StringUtils.isEmpty((Object)bundleCode) || StringUtils.isEmpty((Object)this.dependencies)) {
            return false;
        }
        return this.dependencies.contains(bundleCode);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static Map<Object, WeakReferenceDto.WeakReferenceFieldDto> getProxy2WeakField() {
        return proxy2WeakField;
    }
}

