/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.runner;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.starter.bundle.config.BundleReportModeConfig;
import com.dtyunxi.cube.starter.bundle.config.CubeBundleDataUploadConfig;
import com.dtyunxi.cube.starter.bundle.config.ExtraBundleLoadedConfig;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.dto.BundleDataUploadDto;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleBaseSettingRespDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.enums.BundleReportModeEnum;
import com.dtyunxi.cube.starter.bundle.reader.BundleBaseReader;
import com.dtyunxi.cube.starter.bundle.service.BundleDescService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.net.LocalIpAddress;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class BundleMqSenderRunner
implements CommandLineRunner,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(BundleMqSenderRunner.class);
    private ICommonsMqService commonsMqService;
    private String serviceId;
    private String serviceName;
    private int port;
    private BundleReportModeConfig bundleReportModeConfig;
    private CubeBundleDataUploadConfig cubeBundleDataUploadConfig = new CubeBundleDataUploadConfig();
    private Environment environment;
    private ExtraBundleLoadedConfig extraBundleLoadedConfig;

    public BundleMqSenderRunner(ICommonsMqService commonsMqService, int port, String serviceId, String serviceName, BundleReportModeConfig bundleReportModeConfig) {
        this.commonsMqService = commonsMqService;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
        this.port = port;
        this.bundleReportModeConfig = bundleReportModeConfig;
    }

    public BundleMqSenderRunner(CubeBundleDataUploadConfig cubeBundleDataUploadConfig, ICommonsMqService commonsMqService, int port, String serviceId, String serviceName, BundleReportModeConfig bundleReportModeConfig) {
        this(commonsMqService, port, serviceId, serviceName, bundleReportModeConfig);
        this.cubeBundleDataUploadConfig = cubeBundleDataUploadConfig;
    }

    public BundleMqSenderRunner(ExtraBundleLoadedConfig extraBundleLoadedConfig, CubeBundleDataUploadConfig cubeBundleDataUploadConfig, ICommonsMqService commonsMqService, int port, String serviceId, String serviceName, BundleReportModeConfig bundleReportModeConfig) {
        this(cubeBundleDataUploadConfig, commonsMqService, port, serviceId, serviceName, bundleReportModeConfig);
        this.extraBundleLoadedConfig = extraBundleLoadedConfig;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void run(String ... args) throws Exception {
        BundleBaseReader.initExtraBundleLoadedSet((List)this.extraBundleLoadedConfig.getLoaded());
        Map<String, BundleBaseSettingRespDto> basicAndSettingContent = BundleDescService.readBasicAndSetting();
        Date bootTime = new Date();
        if (this.bundleReportModeConfig.isAsWhole()) {
            BundleDescDto bundleDescDto = this.generateBundleDescDto();
            bundleDescDto.setBootTime(bootTime);
            if (BundleReportModeEnum.MQ.getKey() == this.bundleReportModeConfig.getFlow()) {
                bundleDescDto.setContent(BundleDescService.readAll());
            }
            this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_description.topic:PUBLISH_TOPIC}"), this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_description.tag:BUNDLE_DESCRIPTION_TAG}"), bundleDescDto);
        } else {
            BundleDescDto bundleBasicAndSetting = this.generateBundleDescDto();
            BundleDataUploadDto bundleDataUploadDto = new BundleDataUploadDto();
            BeanUtil.copyProperties((Object)this.cubeBundleDataUploadConfig, (Object)bundleDataUploadDto, (String[])new String[0]);
            bundleBasicAndSetting.setBundleDataUploadDto(bundleDataUploadDto);
            if (this.cubeBundleDataUploadConfig.isBaseSetting()) {
                bundleBasicAndSetting.setBootTime(bootTime);
                if (BundleReportModeEnum.MQ.getKey() == this.bundleReportModeConfig.getBasic()) {
                    bundleBasicAndSetting.setContent(basicAndSettingContent);
                }
                bundleBasicAndSetting.setType(BundleDataTypeEnum.BASE_SETTING.getKey());
                this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_base_setting.topic:PUBLISH_TOPIC}"), this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_base_setting.tag:BUNDLE_BASE_SETTING_TAG}"), bundleBasicAndSetting);
            }
            if (this.cubeBundleDataUploadConfig.isApi()) {
                BundleDescDto bundleApis = this.clone(bundleBasicAndSetting);
                bundleApis.setBootTime(bootTime);
                if (BundleReportModeEnum.MQ.getKey() == this.bundleReportModeConfig.getApi()) {
                    bundleApis.setContent(BundleDescService.readApis());
                }
                bundleApis.setType(BundleDataTypeEnum.API.getKey());
                this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_api.topic:PUBLISH_TOPIC}"), this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_api.tag:BUNDLE_API_TAG}"), bundleApis);
            }
            if (this.cubeBundleDataUploadConfig.isDto()) {
                BundleDescDto bundleDtos = this.clone(bundleBasicAndSetting);
                bundleDtos.setBootTime(bootTime);
                if (BundleReportModeEnum.MQ.getKey() == this.bundleReportModeConfig.getDto()) {
                    bundleDtos.setContent(BundleDescService.readDtos());
                }
                bundleDtos.setType(BundleDataTypeEnum.DTO.getKey());
                this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_dto.topic:PUBLISH_TOPIC}"), this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_dto.tag:BUNDLE_DTO_TAG}"), bundleDtos);
            }
            if (this.cubeBundleDataUploadConfig.isFlow()) {
                BundleDescDto bundleFlows = this.clone(bundleBasicAndSetting);
                bundleFlows.setBootTime(bootTime);
                if (BundleReportModeEnum.MQ.getKey() == this.bundleReportModeConfig.getFlow()) {
                    bundleFlows.setContent(BundleDescService.readFlows());
                }
                bundleFlows.setType(BundleDataTypeEnum.FLOW.getKey());
                this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_flow.topic:PUBLISH_TOPIC}"), this.environment.resolvePlaceholders("${dtyunxi.bundle.mq.bundle_flow.tag:BUNDLE_FLOW_TAG}"), bundleFlows);
            }
        }
    }

    protected <BUNDLE_DATA extends BundleBaseDto> BundleDescDto<Map<String, BUNDLE_DATA>> clone(BundleDescDto<?> bundleDescDto) {
        BundleDescDto newBundleDescDto = new BundleDescDto();
        newBundleDescDto.setIp(bundleDescDto.getIp());
        newBundleDescDto.setPort(bundleDescDto.getPort());
        newBundleDescDto.setServiceId(bundleDescDto.getServiceId());
        newBundleDescDto.setServiceName(bundleDescDto.getServiceName());
        newBundleDescDto.setApplicationVersion(bundleDescDto.getApplicationVersion());
        newBundleDescDto.setApplicationCreateTime(bundleDescDto.getApplicationCreateTime());
        newBundleDescDto.setBundleDataUploadDto(bundleDescDto.getBundleDataUploadDto());
        return newBundleDescDto;
    }

    protected <BUNDLE_DATA extends BundleBaseDto> BundleDescDto<Map<String, BUNDLE_DATA>> generateBundleDescDto() throws UnknownHostException {
        BundleDescDto bundleDescDto = new BundleDescDto();
        bundleDescDto.setIp(LocalIpAddress.resolveLocalIp());
        bundleDescDto.setPort(this.port);
        bundleDescDto.setServiceId(this.serviceId);
        bundleDescDto.setServiceName(this.serviceName);
        Pair<String, Date> pair = this.parseAppJar();
        bundleDescDto.setApplicationVersion((String)pair.key);
        bundleDescDto.setApplicationCreateTime((Date)pair.value);
        return bundleDescDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<String, Date> parseAppJar() {
        String jarFilePath = ClassUtils.getDefaultClassLoader().getResource("").getPath().replace("!/BOOT-INF/classes!/", "");
        logger.info("jarFilePath={}", (Object)jarFilePath);
        if (jarFilePath.startsWith("file")) {
            jarFilePath = jarFilePath.substring("file".length() + 1);
        }
        JarFile jarFile = null;
        InputStream in = null;
        String version = null;
        String strBuildTime = null;
        try {
            MavenXpp3Reader reader;
            Model model;
            if (jarFilePath.endsWith(".jar")) {
                Manifest manifest;
                Attributes maniAttributes;
                jarFile = new JarFile(jarFilePath);
                JarEntry entry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
                if (null != entry && null != (maniAttributes = (manifest = new Manifest(in = jarFile.getInputStream(entry))).getMainAttributes())) {
                    strBuildTime = maniAttributes.getValue("git-build-time");
                    if (StringUtils.isBlank((CharSequence)strBuildTime)) {
                        strBuildTime = maniAttributes.getValue("git-cm-time");
                    }
                    if (StringUtils.isBlank((CharSequence)strBuildTime)) {
                        logger.error("MANIFEST.MF\u4e2d\u627e\u4e0d\u5230\u6253\u5305\u65f6\u95f4{}\u6216\u8005{}", (Object)"git-build-time", (Object)"git-cm-time");
                    }
                    if (StringUtils.isBlank((CharSequence)(version = maniAttributes.getValue("version")))) {
                        logger.error("MANIFEST.MF\u4e2d\u627e\u4e0d\u5230\u7248\u672c\u53f7{}", (Object)"version");
                    }
                    logger.info("buildTime={}, version={}", (Object)strBuildTime, (Object)version);
                }
            } else if (jarFilePath.endsWith("/target/classes/") && StringUtils.isBlank((CharSequence)(version = (model = (reader = new MavenXpp3Reader()).read((Reader)new FileReader((jarFilePath = jarFilePath.substring(0, jarFilePath.lastIndexOf("/target/classes/"))) + File.separator + "pom.xml"))).getVersion()))) {
                version = model.getParent().getVersion();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != jarFile) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return new Pair(version, (Object)(null != strBuildTime ? this.formatBuildTime(strBuildTime) : new Date()));
    }

    protected Date formatBuildTime(String strSrcTime) {
        if (StringUtils.isBlank((CharSequence)strSrcTime)) {
            return null;
        }
        return DateUtil.parseDate((String)strSrcTime, (String)"yyyy-MM-dd'T'HH:mm:ssZ");
    }
}

