/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.cache;

import com.dtyunxi.cube.commons.config.SystemConfig;
import com.dtyunxi.cube.starter.cache.CubeCacheProperties;
import com.dtyunxi.huieryun.cache.api.CacheFactory;
import com.dtyunxi.huieryun.cache.api.IRedisCacheService;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CubeCacheProperties.class})
public class CubeCacheAutoConfiguration {
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${spring.application.name:}")
    private String envModule;
    @Autowired
    private CubeCacheProperties cacheRegistryVo;

    @Bean
    @ConditionalOnMissingBean
    public IRedisCacheService cacheService() {
        String pfile = StringUtils.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        SystemConfig.setActiveProfile((String)this.profile);
        return CacheFactory.createRedisCache((String)(this.envModule + "-" + pfile), (CacheRegistryVo)this.cacheRegistryVo);
    }
}

