/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.caching;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class CachingDelegateEncryptablePropertySource<T>
extends PropertySource<T>
implements EncryptablePropertySource<T> {
    public static final String INITIAL_CAPACITY = System.getProperty("jasypt.caching.map.initialCapacity");
    private final PropertySource<T> delegate;
    private final EncryptablePropertyResolver resolver;
    private final EncryptablePropertyFilter filter;
    private final Map<String, Object> cache;
    private final Logger logger = LoggerFactory.getLogger(CachingDelegateEncryptablePropertySource.class);

    public CachingDelegateEncryptablePropertySource(PropertySource<T> delegate, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter) {
        super(delegate.getName(), delegate.getSource());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("jasypt\u914d\u7f6e\u52a0\u5bc6\u63d2\u4ef6\u5bfc\u81f4\u7684ConcurrentHashMap\u6269\u5bb9\u8fdb\u5165\u6b7b\u5faa\u73afbug\u89c4\u907f\u6539\u9020\u7c7b");
        }
        Assert.notNull(delegate, (String)"PropertySource delegate cannot be null");
        Assert.notNull((Object)resolver, (String)"EncryptablePropertyResolver cannot be null");
        Assert.notNull((Object)filter, (String)"EncryptablePropertyFilter cannot be null");
        this.delegate = delegate;
        this.resolver = resolver;
        this.filter = filter;
        this.cache = new HashMap<String, Object>(INITIAL_CAPACITY == null ? 1024 : Integer.parseInt(String.valueOf(INITIAL_CAPACITY)));
    }

    public PropertySource<T> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        CachingDelegateEncryptablePropertySource cachingDelegateEncryptablePropertySource = this;
        synchronized (cachingDelegateEncryptablePropertySource) {
            Object resolved;
            if (!this.cache.containsKey(name) && (resolved = this.getProperty(this.resolver, this.filter, this.delegate, name)) != null) {
                this.cache.put(name, resolved);
            }
            return this.cache.get(name);
        }
    }

    public void refresh() {
        this.cache.clear();
    }
}

