/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.meta.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.starter.meta.dto.ColumnSourceDto;
import com.dtyunxi.cube.starter.meta.service.IColumnSourceService;
import com.dtyunxi.cube.starter.meta.utils.FileUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.meta.das.AttributeDas;
import com.dtyunxi.yundt.cube.meta.das.EntityDas;
import com.dtyunxi.yundt.cube.meta.eo.AttributeEo;
import com.dtyunxi.yundt.cube.meta.eo.EntityEo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ColumnSourceServiceImpl
implements IColumnSourceService {
    private static final Logger logger = LoggerFactory.getLogger(ColumnSourceServiceImpl.class);
    @Resource
    private AttributeDas attributeDas;
    @Resource
    private EntityDas entityDas;

    @Override
    public void updateColumnRefInfo() {
        try {
            logger.debug("\u5f00\u59cb\u8bfb\u53d6 {}", (Object)"META-INF/bundle-eo-ref-table.json");
            ColumnSourceDto refTableDto = this.loadFromFile("META-INF/bundle-eo-ref-table.json");
            List<AttributeEo> attributeEoList = this.getUpdateAttributeEo(refTableDto);
            for (AttributeEo attributeEo : attributeEoList) {
                this.attributeDas.updateSelective((BaseEo)attributeEo);
            }
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7d\u5173\u8054\u8868Json\u6587\u4ef6\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<AttributeEo> getUpdateAttributeEo(ColumnSourceDto refTableDto) {
        Map<String, Map<String, ColumnSourceDto.ColumnSource>> columnSourceMap = refTableDto.getRefTableMap();
        if (CollectionUtils.isEmpty(columnSourceMap)) {
            return Lists.newArrayList();
        }
        ArrayList updateAttributeEoList = Lists.newArrayList();
        Set<Map.Entry<String, Map<String, ColumnSourceDto.ColumnSource>>> entrySet = columnSourceMap.entrySet();
        for (Map.Entry<String, Map<String, ColumnSourceDto.ColumnSource>> entry : entrySet) {
            String entityCode = entry.getKey();
            EntityEo entityEo = new EntityEo();
            entityEo.setCode(entityCode);
            List eoList = this.entityDas.select((BaseEo)entityEo, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isEmpty((Collection)eoList)) {
                logger.warn("\u6839\u636e\u5b9e\u4f53\u7f16\u7801\u627e\u4e0d\u5230\u5b9e\u4f53\u4fe1\u606f\uff0c\u5b9e\u4f53\u7f16\u7801:" + entityCode);
                continue;
            }
            entityEo = (EntityEo)eoList.get(0);
            AttributeEo attributeEo = new AttributeEo();
            attributeEo.setEntityId(entityEo.getId());
            List attributeEoList = this.attributeDas.select((BaseEo)attributeEo, Integer.valueOf(1), Integer.valueOf(1000));
            if (CollectionUtils.isEmpty((Collection)attributeEoList)) {
                logger.warn("{} \u5b9e\u4f53\u6ca1\u6709\u5c5e\u6027", (Object)entityEo);
                continue;
            }
            Map<String, AttributeEo> attributeEoMap = attributeEoList.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
            Map<String, ColumnSourceDto.ColumnSource> refInfoMap = entry.getValue();
            Set<Map.Entry<String, ColumnSourceDto.ColumnSource>> refInfoEntrySet = refInfoMap.entrySet();
            for (Map.Entry<String, ColumnSourceDto.ColumnSource> refInfoEntry : refInfoEntrySet) {
                String columnName = refInfoEntry.getKey();
                AttributeEo attribute = attributeEoMap.get(columnName);
                ColumnSourceDto.ColumnSource columnSource = refInfoMap.get(columnName);
                AttributeEo updateAttributeEo = new AttributeEo();
                updateAttributeEo.setId(attribute.getId());
                updateAttributeEo.setSourceEntity(columnSource.getSourceEntity());
                updateAttributeEo.setSourceDomain(columnSource.getSourceDomain());
                updateAttributeEo.setSourceAttr(columnSource.getSourceAttr());
                updateAttributeEo.setSourceDisplayAttr(columnSource.getSourceDisplayAttr());
                updateAttributeEo.setSourceDict(columnSource.getSourceDict());
                updateAttributeEoList.add(updateAttributeEo);
            }
        }
        return updateAttributeEoList;
    }

    private ColumnSourceDto loadFromFile(String fileName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> jsonFiles = classLoader.getResources(fileName);
        ColumnSourceDto columnSourceDto = new ColumnSourceDto();
        while (jsonFiles.hasMoreElements()) {
            String json = FileUtil.load2Json(jsonFiles.nextElement());
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                ColumnSourceDto singleDto = (ColumnSourceDto)jsonObject.toJavaObject(ColumnSourceDto.class);
                Map<String, Map<String, ColumnSourceDto.ColumnSource>> map = columnSourceDto.getRefTableMap();
                if (null != map) {
                    map.putAll(singleDto.getRefTableMap());
                    continue;
                }
                columnSourceDto.setRefTableMap(singleDto.getRefTableMap());
            }
            catch (Throwable throwable) {
                logger.warn("{}\u6587\u4ef6\u5185\u5bb9\u89e3\u6790\u6210json\u5f02\u5e38\uff1a", (Object)fileName, (Object)throwable);
            }
        }
        return columnSourceDto;
    }
}

