/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.meta;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.starter.meta.service.IColumnSourceService;
import com.dtyunxi.cube.starter.meta.service.IDataLimitFunctionService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.meta.dto.response.MetaDomainDto;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class MetaLoader
implements CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(MetaLoader.class);
    private static String META_FOLDER = "meta";
    @Value(value="${spring.application.name}")
    private String moduleName;
    @Value(value="${dtyunxi.cube.starter.data.limit.enable:false}")
    private boolean enableDataLimit = false;
    @Resource
    private ICacheService cacheService;
    @Autowired(required=false)
    private IColumnSourceService columnSourceService;
    @Autowired(required=false)
    private IDataLimitFunctionService dataLimitFunctionService;

    public void run(String ... args) throws Exception {
        this.loadMeta();
        if (this.enableDataLimit) {
            logger.info("\u6570\u636e\u6743\u9650\u5f00\u5173\u5df2\u5f00\u542f...");
            this.columnSourceService.updateColumnRefInfo();
            this.dataLimitFunctionService.loadFunction();
        }
    }

    public void loadMeta() {
        if (StringUtils.isBlank((CharSequence)this.moduleName)) {
            logger.error("spring.application.name\u7f3a\u5931");
            return;
        }
        String metaFileName = this.moduleName + ".json";
        String path = META_FOLDER + File.separator + metaFileName;
        ClassPathResource resource = new ClassPathResource(path);
        if (!resource.exists()) {
            logger.warn("\u627e\u4e0d\u5230\u5143\u6570\u636e\u5b9a\u4e49\u6587\u4ef6\uff0c\u505c\u6b62\u89e3\u6790");
            return;
        }
        MetaDomainDto metaDomainDto = null;
        try {
            metaDomainDto = (MetaDomainDto)JSON.parseObject((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8, MetaDomainDto.class, (Feature[])new Feature[]{Feature.AllowSingleQuotes, Feature.UseBigDecimal, Feature.AllowComment, Feature.AutoCloseSource});
        }
        catch (Exception e) {
            logger.error("\u5143\u6570\u636e\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            return;
        }
        String key = "META_" + metaDomainDto.getCode();
        String metaStr = JSON.toJSONString((Object)metaDomainDto);
        String cacheStr = (String)this.cacheService.getCache(key, String.class);
        if (metaStr.equals(cacheStr)) {
            logger.debug("\u5143\u6570\u636e\u5df2\u7f13\u5b58");
            return;
        }
        this.cacheService.setCache(key, (Object)metaStr);
    }
}

