/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.swagger;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConfigurationProperties(prefix="dtyunxi.cube.swagger")
@EnableSwagger2
public class SwaggerConfigure {
    @Value(value="${swagger.enabled:false}")
    private Boolean isEnable;
    private String title = "\u4e91\u5f99\u79d1\u6280\u4e2d\u53f0API";
    private String description = "\u4e91\u5f99\u79d1\u6280\u4e2d\u53f0API";
    private String basePackage = "com.dtyunxi.yundt.center";
    private String version = "1.0.0";
    private String baseUrl;

    @Bean
    public Docket createRestApi() {
        ParameterBuilder aParameterBuilder = new ParameterBuilder();
        aParameterBuilder.name("Application-Key").description("\u5e94\u7528\u5b9e\u4f8bKey").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build();
        ParameterBuilder aParameterBuilder1 = new ParameterBuilder();
        aParameterBuilder1.name("Access-Token").description("\u8bbf\u95ee\u4ee4\u724c").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build();
        ArrayList<Parameter> aParameters = new ArrayList<Parameter>();
        aParameters.add(aParameterBuilder.build());
        aParameters.add(aParameterBuilder1.build());
        return new Docket(DocumentationType.SWAGGER_2).enable(this.isEnable.booleanValue()).host(this.baseUrl).globalOperationParameters(aParameters).apiInfo(this.apiInfo()).select().apis(this.basePackage(this.basePackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).description(this.description).termsOfServiceUrl("http://").contact("\u4e91\u5f99\u79d1\u6280IT").version(this.version).build();
    }

    public Predicate<RequestHandler> basePackage(final String basePackage) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return (Boolean)SwaggerConfigure.declaringClass(input).transform(SwaggerConfigure.this.handlerPackage(basePackage)).or((Object)true);
            }
        };
    }

    private Function<Class<?>, Boolean> handlerPackage(final String basePackage) {
        return new Function<Class<?>, Boolean>(){

            public Boolean apply(Class<?> input) {
                for (String strPackage : basePackage.split(",")) {
                    boolean isMatch = input.getPackage().getName().startsWith(strPackage);
                    if (!isMatch) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable((Object)input.declaringClass());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

