/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.swagger;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.plugin.swagger.SwaggerProperties;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spring.web.plugins.Docket;

@ConditionalOnProperty(value={"swagger.enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@EnableOpenApi
public class SwaggerConfigure {
    private static final String[] protocols = new String[]{"https", "http"};
    private static final Map<String, String> HEADER_PARAMS = new HashMap<String, String>(8);

    @Bean
    public Docket docket(SwaggerProperties prop, ObjectProvider<Function<Docket, Docket>> provider) {
        Docket docket = new Docket(prop.getDocumentationType()).host(prop.getBaseUrl()).enable(prop.getIsEnable().booleanValue()).apiInfo(this.apiInfo(prop)).pathMapping(prop.getContextPath()).select().apis(this.basePackage(prop.getBasePackage())).apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build().globalRequestParameters(this.globalParameters()).protocols(new HashSet<String>(Arrays.asList(protocols)));
        Function function = (Function)provider.getIfAvailable();
        if (function != null) {
            docket = (Docket)function.apply(docket);
        }
        return docket;
    }

    private List<RequestParameter> globalParameters() {
        List<RequestParameter> aParameters = HEADER_PARAMS.entrySet().stream().map(entry -> new RequestParameterBuilder().name((String)entry.getKey()).description((String)entry.getValue()).in("header").build()).collect(Collectors.toList());
        return aParameters;
    }

    private ApiInfo apiInfo(SwaggerProperties prop) {
        return new ApiInfoBuilder().title(prop.getTitle()).description(prop.getDescription()).version(prop.getVersion()).termsOfServiceUrl("http://").build();
    }

    public Predicate<RequestHandler> basePackage(String basePackage) {
        if (StrUtil.isBlank((CharSequence)basePackage)) {
            return requestHandler -> false;
        }
        String[] basePackages = basePackage.split(",");
        return requestHandler -> Optional.ofNullable(requestHandler.declaringClass()).map(e -> {
            String clzPackage = ClassUtils.getPackageName((Class)e);
            return Arrays.stream(basePackages).anyMatch(clzPackage::startsWith);
        }).orElse(false);
    }

    static {
        HEADER_PARAMS.put("Application-Key", "\u5e94\u7528\u5b9e\u4f8bKey");
        HEADER_PARAMS.put("Access-Token", "\u8bbf\u95ee\u4ee4\u724c");
        HEADER_PARAMS.put("yes.req.applicationId", "\u8eab\u4efd\u8bc1\u660e-\u5e94\u7528id");
        HEADER_PARAMS.put("yes.req.instanceId", "\u8eab\u4efd\u8bc1\u660e-\u5b9e\u4f8bid");
        HEADER_PARAMS.put("yes.req.tenantId", "\u8eab\u4efd\u8bc1\u660e-\u79df\u6237id");
    }
}

