/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.support.nacos;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ClassPathResource;

public class NacosConfigPreparedListener
implements SpringApplicationRunListener {
    protected static final Logger LOG = LoggerFactory.getLogger(NacosConfigPreparedListener.class);
    private static final AtomicBoolean initFlag = new AtomicBoolean(false);

    public NacosConfigPreparedListener(SpringApplication application, String[] args) {
        LOG.info("with application={},args={}", (Object)application, (Object)args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        if (initFlag.getAndSet(true)) {
            return;
        }
        LOG.info("environmentPrepared,bootstrapContext={},environment={}", bootstrapContext.getClass(), environment.getClass());
        ClassPathResource fileResource = new ClassPathResource("/config/nacos-config.properties", NacosConfigPreparedListener.class.getClassLoader());
        Properties properties = new Properties();
        Map systemProperties = environment.getSystemProperties();
        InputStream inputStream = null;
        try {
            inputStream = fileResource.getInputStream();
            properties.load(inputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (StrUtil.isBlankIfStr((Object)entry.getValue())) continue;
                String key = (String)entry.getKey();
                String value = environment.resolvePlaceholders((String)entry.getValue());
                LOG.info("key={},value={}", (Object)key, (Object)value);
                if (!StrUtil.isNotBlank((CharSequence)value) || value.startsWith("${") && value.endsWith("}")) continue;
                systemProperties.put(key, value);
            }
        }
        catch (IOException e) {
            LOG.error("\u8bfb\u53d6\u5c5e\u6027\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

