/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.domain.event.config;

import com.dtyunxi.cube.domain.event.cache.LocalCache;
import com.dtyunxi.cube.domain.event.constant.SendFlag;
import com.dtyunxi.cube.domain.event.service.IDomainEventService;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.DEParameterChangedDto;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public class DEBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
PriorityOrdered {
    private static final Logger logger = LoggerFactory.getLogger(DEBeanPostProcessor.class);
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(@Nonnull Object bean, String beanName) throws BeansException {
        Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        Object target = AopUtils.isAopProxy((Object)bean) ? AopProxyUtils.getSingletonTarget((Object)bean) : bean;
        ReflectionUtils.doWithFields((Class)beanClass, field -> {
            Class<?> fieldClazz = field.getType();
            if (ICommonsMqService.class.isAssignableFrom(fieldClazz) && !IDomainEventService.class.isAssignableFrom(beanClass)) {
                logger.info("\u51c6\u5907\u6ce8\u5165\uff0cbeanClass\uff1a" + beanClass.getCanonicalName() + "\uff0cbeanName\uff1a" + beanName + "\uff0cfieldName\uff1a" + field.getName());
                this.injectMqPulibsh(beanClass, target, field, fieldClazz);
            }
        }, field -> field.isAnnotationPresent(Autowired.class) || field.isAnnotationPresent(Resource.class));
        return bean;
    }

    private void injectMqPulibsh(Class<?> beanClass, Object target, Field field, Class<?> fieldClazz) {
        Object proxy = Proxy.newProxyInstance(fieldClazz.getClassLoader(), new Class[]{fieldClazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Object.class.equals(method.getDeclaringClass())) {
                    return method.invoke((Object)this, args);
                }
                ICommonsMqService commonsMqService = (ICommonsMqService)DEBeanPostProcessor.this.beanFactory.getBean(ICommonsMqService.class);
                if (!method.getName().startsWith("publish")) {
                    return method.invoke((Object)commonsMqService, args);
                }
                String domainEventCode = null;
                for (Object arg : args) {
                    domainEventCode = LocalCache.getDtoCode2DomainEvent().get(arg.getClass().getCanonicalName());
                    if (null != domainEventCode) break;
                }
                if (null == domainEventCode) {
                    return method.invoke((Object)commonsMqService, args);
                }
                DEParameterChangedDto.DomainEventParameter parameter = LocalCache.getDomainEventParameterMap().get(domainEventCode);
                if (null == parameter) {
                    return method.invoke((Object)commonsMqService, args);
                }
                if (parameter.getSendFlag().equals(SendFlag.YES.getValue())) {
                    return method.invoke((Object)commonsMqService, args);
                }
                return MessageResponse.SUCCESS;
            }
        });
        try {
            ReflectionUtils.makeAccessible((Field)field);
            field.set(target, proxy);
        }
        catch (IllegalAccessException e) {
            logger.warn("\u6ce8\u5165{}\u7684{}\u5b57\u6bb5\u5931\u8d25:{}", new Object[]{beanClass.getCanonicalName(), field.getName(), e.getMessage()});
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

