/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.domain.event.config;

import com.dtyunxi.cube.domain.event.config.DEBeanPostProcessor;
import com.dtyunxi.cube.domain.event.constant.CommunicateType;
import com.dtyunxi.cube.domain.event.mq.DEParameterChangedProcess;
import com.dtyunxi.cube.domain.event.runner.PullDomainEventParameterRunner;
import com.dtyunxi.cube.domain.event.service.IDomainEventService;
import com.dtyunxi.cube.domain.event.service.impl.MqDomainEventServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"dtyunxi.yundt.cube.conf.domain-event"}, havingValue="true", matchIfMissing=true)
@Configuration
public class CubeAutoConfiguration {
    @Value(value="${domain.event.communicate.type:MQ}")
    private String communicateType;

    @Bean
    public DEParameterChangedProcess parameterChangedProcess() {
        return new DEParameterChangedProcess();
    }

    @Bean
    public static DEBeanPostProcessor deBeanPostProcessor() {
        return new DEBeanPostProcessor();
    }

    @ConditionalOnMissingBean
    @Bean
    public PullDomainEventParameterRunner pullDomainEventParameterRunner() {
        return new PullDomainEventParameterRunner();
    }

    @Bean
    public IDomainEventService domainEventService() {
        MqDomainEventServiceImpl domainEventService = null;
        CommunicateType type = CommunicateType.valueOf(this.communicateType.toUpperCase());
        switch (type) {
            case MQ: {
                domainEventService = new MqDomainEventServiceImpl();
                break;
            }
        }
        return domainEventService;
    }
}

