/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.domain.event.runner;

import com.dtyunxi.cube.domain.event.cache.LocalCache;
import com.dtyunxi.cube.domain.event.service.IDomainEventListener;
import com.dtyunxi.cube.enhance.extension.DomainEventListener;
import com.dtyunxi.cube.plugin.mq.IMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.MQProcessorRegisterDto;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.cube.utils.Util;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.DEParameterChangedDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class MQRegisterExtRunner
implements EnvironmentAware,
BeanFactoryAware,
IMQConsumerRegister {
    private static final Logger logger = LoggerFactory.getLogger(MQRegisterExtRunner.class);
    private ListableBeanFactory beanFactory;
    private final TopicRegistryVo topicRegistryVo;
    private final MessageRegistryVo registryVo;
    private final String consumer;
    private Environment environment;
    @Value(value="${domain.event.local.cache.load.wait.time:2}")
    private Integer localCacheLoadWaitTime;

    public MQRegisterExtRunner(MessageRegistryVo registryVo, TopicRegistryVo topicRegistryVo, String consumer) {
        this.registryVo = registryVo;
        this.topicRegistryVo = topicRegistryVo;
        this.consumer = consumer;
    }

    public List<MQProcessorRegisterDto> getMQProcessorRegisters() {
        ArrayList<MQProcessorRegisterDto> registeredProcessorList = new ArrayList<MQProcessorRegisterDto>();
        Collection messageProcessors = this.getBeanFactory().getBeansOfType(IDomainEventListener.class).values();
        if (CollectionUtils.isEmpty(messageProcessors)) {
            return new ArrayList<MQProcessorRegisterDto>();
        }
        while (!LocalCache.isDomainEventInitCompleted().booleanValue()) {
            try {
                TimeUnit.SECONDS.sleep(this.localCacheLoadWaitTime.intValue());
            }
            catch (InterruptedException e) {
                logger.error("\u7b49\u5f85\u9886\u57df\u4e8b\u4ef6\u672c\u5730\u7f13\u5b58\u52a0\u8f7d\u65f6\u51fa\u9519\uff0c", (Throwable)e);
            }
        }
        for (IDomainEventListener bean : messageProcessors) {
            Class<?> beanClass = AopUtils.isAopProxy((Object)bean) ? AopProxyUtils.ultimateTargetClass((Object)bean) : bean.getClass();
            Class parameterClass = Util.readGenericParamType(beanClass);
            DEParameterChangedDto.DomainEventParameter parameter = LocalCache.getParameterByDtoCode(parameterClass.getCanonicalName());
            if (null == parameter) {
                logger.error("\u6839\u636e\u4e8b\u4ef6dto\u7f16\u7801\u627e\u4e0d\u5230\u9886\u57df\u4e8b\u4ef6\u53c2\u6570\uff0cdtoCode\uff1a" + parameterClass.getCanonicalName());
                continue;
            }
            String topic = parameter.getTopic();
            String tag = parameter.getTag();
            String msgType = "publish";
            String consumer = beanClass.isAnnotationPresent(DomainEventListener.class) ? CommonsMqHelper.parseConsumer((MessageRegistryVo)this.getRegistryVo(), (String)beanClass.getAnnotation(DomainEventListener.class).consumer(), (String)this.getConsumer()) : CommonsMqHelper.parseConsumer((MessageRegistryVo)this.getRegistryVo(), (String)"", (String)this.getConsumer());
            if (StringUtils.isBlank((CharSequence)topic)) {
                topic = this.getTopicRegistryVo().getPublishTopic();
            }
            topic = this.environment.resolvePlaceholders(topic);
            tag = this.environment.resolvePlaceholders(tag);
            logger.info("\u9886\u57df\u4e8b\u4ef6\u8ba2\u9605\u8005\u6ce8\u518c\uff0ctopic: {}, consumer: {}, tag: {}, msgType: {}, bean: {}", new Object[]{topic, consumer, tag, msgType, bean.getClass()});
            MQProcessorRegisterDto mqProcessorRegisterDto = new MQProcessorRegisterDto();
            mqProcessorRegisterDto.setTopic(topic);
            mqProcessorRegisterDto.setConsumer(consumer);
            mqProcessorRegisterDto.setTag(tag);
            mqProcessorRegisterDto.setMsgType(msgType);
            mqProcessorRegisterDto.setBean((IMessageProcessor)bean);
            registeredProcessorList.add(mqProcessorRegisterDto);
        }
        return registeredProcessorList;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public TopicRegistryVo getTopicRegistryVo() {
        return this.topicRegistryVo;
    }

    public MessageRegistryVo getRegistryVo() {
        return this.registryVo;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Integer getLocalCacheLoadWaitTime() {
        return this.localCacheLoadWaitTime;
    }

    public void setLocalCacheLoadWaitTime(Integer localCacheLoadWaitTime) {
        this.localCacheLoadWaitTime = localCacheLoadWaitTime;
    }

    public static Logger getLogger() {
        return logger;
    }
}

