/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JavaparserUtil {
    public static VariableDeclarator readVariableDeclaratorFromField(FieldDeclaration fieldDeclaration) {
        for (Node childNode : fieldDeclaration.getChildNodes()) {
            if (!(childNode instanceof VariableDeclarator)) continue;
            return (VariableDeclarator)childNode;
        }
        return null;
    }

    public static String readFieldName(FieldDeclaration fieldDeclaration) {
        VariableDeclarator declarator = JavaparserUtil.readVariableDeclaratorFromField(fieldDeclaration);
        return declarator.getName().getIdentifier();
    }

    public static Class<?> fetchClass(CompilationUnit unit) {
        String canonicalName = JavaparserUtil.compilationUnit2canonicalName(unit);
        try {
            return Class.forName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String compilationUnit2canonicalName(CompilationUnit unit) {
        String classCanonicalName = ((TypeDeclaration)unit.getTypes().get(0)).getNameAsString();
        Optional packageDeclaration = unit.getPackageDeclaration();
        if (packageDeclaration.isPresent()) {
            classCanonicalName = ((PackageDeclaration)packageDeclaration.get()).getNameAsString() + "." + classCanonicalName;
        }
        return classCanonicalName;
    }

    public static FieldDeclaration findField(CompilationUnit unit, String fieldName) {
        for (BodyDeclaration member : unit.getType(0).getMembers()) {
            FieldDeclaration fieldDeclaration;
            String curFieldName;
            if (!(member instanceof FieldDeclaration) || !fieldName.equals(curFieldName = JavaparserUtil.readFieldName(fieldDeclaration = (FieldDeclaration)member))) continue;
            return fieldDeclaration;
        }
        return null;
    }

    public static AnnotationExpr findAnnotationExpr(BodyDeclaration bodyDeclaration, Class cubeValueClass) {
        NodeList annotations = bodyDeclaration.getAnnotations();
        for (AnnotationExpr annotation : annotations) {
            String annotationClassName = annotation.getNameAsString();
            if (!annotationClassName.equals(cubeValueClass.getSimpleName()) && !annotationClassName.equals(cubeValueClass.getSimpleName())) continue;
            return annotation;
        }
        return null;
    }

    public static List<String> extraParameterTypes(NodeList<Parameter> parameters) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        if (parameters != null && !parameters.isEmpty()) {
            for (Parameter parameter : parameters) {
                String typeName = parameter.getType().asString();
                if (String.class.getSimpleName().equals(typeName)) {
                    typeName = String.class.getCanonicalName();
                }
                parameterTypeNames.add(typeName);
            }
        }
        return parameterTypeNames;
    }

    public static List<String> extraParameterNames(NodeList<Parameter> parameters) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        if (parameters != null && !parameters.isEmpty()) {
            for (Parameter parameter : parameters) {
                String typeName = parameter.getNameAsString();
                parameterTypeNames.add(typeName);
            }
        }
        return parameterTypeNames;
    }

    public static String packCanonicalName(String typeName, CompilationUnit unit) {
        NodeList imports = unit.getImports();
        for (ImportDeclaration importDeclaration : imports) {
            String importName = importDeclaration.getNameAsString();
            if (!importName.endsWith("." + typeName)) continue;
            return importName;
        }
        return typeName;
    }
}

