/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.enhance.generator.annotation.ExceptionEnum;
import com.dtyunxi.cube.maven.plugin.AbstractCubeMojo;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.ErrorCodeDto;
import com.dtyunxi.cube.maven.plugin.scan.util.CenterNameUtil;
import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.util.JacksonUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.util.FileCopyUtils;

@Mojo(name="gen-error-code-json", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class ErrorCodeScanMojo
extends AbstractCubeMojo {
    @Parameter(defaultValue="${project.parent.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.name}", readonly=true)
    private String name;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;

    @Override
    protected void executeComplement() throws Exception {
        File file;
        File parentFile;
        List classes = this.compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), this.classLoader).stream()).collect(Collectors.toList());
        List enumClzs = classes.stream().filter(r -> r.isEnum() && r.getAnnotation(ExceptionEnum.class) != null).collect(Collectors.toList());
        ArrayList errorCodeDtos = new ArrayList();
        String centerName = CenterNameUtil.getCenterName(this.mavenProject.getResources());
        if (CollectionUtils.isNotEmpty(enumClzs)) {
            enumClzs.stream().map(clz -> {
                try {
                    T[] objects = clz.getEnumConstants();
                    Method getCode = clz.getMethod("getCode", new Class[0]);
                    Method getMessage = clz.getMethod("getMsg", new Class[0]);
                    for (Object o : objects) {
                        ErrorCodeDto errorCodeDto = new ErrorCodeDto();
                        errorCodeDto.setModuleCode(this.artifactId);
                        if (StringUtils.isBlank((CharSequence)centerName)) {
                            errorCodeDto.setModuleName(this.name);
                        } else {
                            errorCodeDto.setModuleName(centerName);
                        }
                        errorCodeDto.setCode(getCode.invoke(o, new Object[0]).toString());
                        errorCodeDto.setMessage(getMessage.invoke(o, new Object[0]).toString());
                        errorCodeDtos.add(errorCodeDto);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }).collect(Collectors.toList());
        }
        if ((parentFile = (file = new File(this.outputDirectory + File.separator + Constants.RESOURCE_ERROR_CODE_LOCATION)).getParentFile()).exists() || parentFile.mkdirs()) {
            try {
                FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson(errorCodeDtos)).getBytes(StandardCharsets.UTF_8), (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLog().info((CharSequence)("\u751f\u6210" + Constants.RESOURCE_ERROR_CODE_LOCATION + "\u6587\u4ef6\u6210\u529f"));
        }
    }
}

