/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.extension.DomainEvent;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.BundleSettingDto;
import com.dtyunxi.cube.maven.plugin.scan.dto.DtoJson;
import com.dtyunxi.cube.maven.plugin.scan.mojo.BaseScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.DtoScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.util.PropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.CollectionUtils;

public class EventScanMojo
extends BaseScanMojo {
    public EventScanMojo(MavenProject mavenProject, Log log) {
        super(mavenProject, log);
    }

    @Override
    public void execute() {
        try {
            List<Class<?>> classes = this.getModuleClasses();
            List<Class> eventClassList = classes.stream().filter(clazz -> clazz.isAnnotationPresent(DomainEvent.class)).collect(Collectors.toList());
            List<BundleSettingDto.Setting> settings = this.readDomainEvent(eventClassList);
            BundleSettingDto projectSettings = new BundleSettingDto();
            projectSettings.setGroupId(this.groupId);
            projectSettings.setArtifactId(this.parentArtifactId);
            projectSettings.setVersion(this.version);
            projectSettings.setSettings(settings);
            this.writeFile(projectSettings, Constants.DOMAIN_EVENT_LOCATION);
            DtoJson dtoJson = DtoScanMojo.getDtoJson(eventClassList);
            if (dtoJson == null) {
                return;
            }
            dtoJson.setArtifactId(this.parentArtifactId);
            dtoJson.setGroupId(this.groupId);
            dtoJson.setVersion(this.version);
            this.writeFile((Object)dtoJson, Constants.RESOURCE_EVENT_DTO_LOCATION);
        }
        catch (Exception e) {
            this.log.error((CharSequence)"\u751f\u6210\u9886\u57df\u4e8b\u4ef6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private List<BundleSettingDto.Setting> readDomainEvent(List<Class> classes) {
        List<BundleSettingDto.Setting> settings = new ArrayList<BundleSettingDto.Setting>();
        if (CollectionUtils.isEmpty(classes)) {
            return settings;
        }
        PropertyUtil.getProperties(this.mavenProject, this.log);
        settings = classes.stream().map(clazz -> this.parseDomainEvent((Class)clazz, clazz.getAnnotation(DomainEvent.class))).collect(Collectors.toList());
        return settings;
    }

    private BundleSettingDto.Setting parseDomainEvent(Class clazz, DomainEvent domainEvent) {
        BundleSettingDto.Setting setting = new BundleSettingDto.Setting();
        setting.setViewVisible(BundleSettingDto.ViewVisible.YES.getValue());
        setting.setIsMultiChoice(BundleSettingDto.MultiChoice.YES.getValue());
        setting.setCode(PropertyUtil.replacePlaceHolder(domainEvent.code()));
        setting.setCapabilityCode(PropertyUtil.replacePlaceHolder(domainEvent.capabilityCode()));
        setting.setName(domainEvent.name());
        setting.setDescr(domainEvent.descr());
        setting.setEditType(BundleSettingDto.EditType.SELECT.getValue());
        setting.setValueType(BundleSettingDto.ValueType.DOMAIN_EVENT_EXT.getValue());
        this.log.info((CharSequence)("\u66ff\u6362\u524dtopic\uff1a" + domainEvent.topic() + "\uff0c\u66ff\u6362\u524dtag\uff1a" + domainEvent.tag()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendFlag", (Object)BundleSettingDto.SendFlag.YES.getValue());
        jsonObject.put("topic", (Object)domainEvent.topic());
        jsonObject.put("tag", (Object)domainEvent.tag());
        jsonObject.put("dtoCode", (Object)clazz.getCanonicalName());
        setting.setParameter(jsonObject.toJSONString());
        this.log.info((CharSequence)("\u66ff\u6362\u540etopic\uff1a" + jsonObject.getString("topic") + "\uff0c\u66ff\u6362\u540etag\uff1a" + jsonObject.getString("tag")));
        return setting;
    }
}

