/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ConvertNode;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.FlowNodeDto;
import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ReflectionUtils;

public class FlowNodeScanMojo
extends AbstractMojo {
    private Log log;
    private String outputDirectory;
    private MavenProject mavenProject;

    public FlowNodeScanMojo(MavenProject mavenProject, Log log) {
        this.log = log;
        this.mavenProject = mavenProject;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List compileClasspathElements;
        this.log = this.getLog();
        try {
            compileClasspathElements = this.mavenProject.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e2) {
            throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e2);
        }
        this.outputDirectory = this.mavenProject.getBuild().getOutputDirectory();
        String groupId = this.mavenProject.getGroupId();
        String artifactId = this.mavenProject.getArtifactId();
        String version = this.mavenProject.getVersion();
        try {
            URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
            compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(classLoader, e));
            String domain = "all";
            List<Class> classes = compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), classLoader).stream()).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(classes)) {
                return;
            }
            LinkedList actionNodes = Lists.newLinkedList();
            LinkedList convertNodes = Lists.newLinkedList();
            classes.forEach(e -> {
                ReflectionUtils.doWithMethods((Class)e, method -> {
                    ActionNode annotation = method.getAnnotation(ActionNode.class);
                    FlowNodeDto.FlowNode node = new FlowNodeDto.FlowNode();
                    node.setCode(method.getDeclaringClass().getCanonicalName() + "#" + method.getName());
                    node.setDocType(domain + "." + annotation.entity().getName());
                    node.setName(annotation.name());
                    node.setInputCode(method.getGenericParameterTypes()[0].getTypeName());
                    node.setOutputCode(method.getGenericReturnType().getTypeName());
                    List<FlowNodeDto.FlowNode.Result> results = Arrays.stream(annotation.results()).map(r -> {
                        FlowNodeDto.FlowNode.Result result = new FlowNodeDto.FlowNode.Result();
                        result.setCode(r.code());
                        result.setDesc(r.desc());
                        result.setName(r.desc());
                        result.setCall(r.call());
                        return result;
                    }).collect(Collectors.toList());
                    node.setResults(results);
                    actionNodes.add(node);
                }, method -> method.isAnnotationPresent(ActionNode.class));
                ReflectionUtils.doWithMethods((Class)e, method -> {
                    ConvertNode annotation = method.getAnnotation(ConvertNode.class);
                    FlowNodeDto.ConvertNode node = new FlowNodeDto.ConvertNode();
                    node.setCode(method.getDeclaringClass().getCanonicalName() + "#" + method.getName());
                    node.setName(annotation.name());
                    node.setInputCode(method.getGenericParameterTypes()[0].getTypeName());
                    node.setOutputCode(method.getGenericReturnType().getTypeName());
                    convertNodes.add(node);
                }, method -> method.isAnnotationPresent(ConvertNode.class));
            });
            FlowNodeDto dto = new FlowNodeDto();
            dto.setGroupId(groupId);
            dto.setArtifactId(artifactId);
            dto.setVersion(version);
            dto.setFlowNodes(actionNodes);
            dto.setConvertNodes(convertNodes);
            if (CollectionUtil.isNotEmpty((Collection)actionNodes) || CollectionUtil.isNotEmpty((Collection)convertNodes)) {
                this.writeFile(dto, Constants.FLOW_NODE_LOCATION);
            }
        }
        catch (Exception e3) {
            this.log.error((CharSequence)("\u751f\u6210" + Constants.FLOW_NODE_LOCATION + "\u6587\u4ef6\u5931\u8d25"), (Throwable)e3);
        }
    }

    public void writeFile(Object obj, String filepath) throws IOException {
        File file = new File(this.outputDirectory + File.separator + filepath);
        File parentFile = file.getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson((Object)obj)).getBytes(StandardCharsets.UTF_8), (File)file);
            this.log.info((CharSequence)("\u751f\u6210" + file + "\u6587\u4ef6\u6210\u529f"));
        } else {
            this.log.error((CharSequence)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25:" + parentFile.getAbsolutePath()));
        }
    }
}

