/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScanJarClzUtil {
    private static final Logger log = LoggerFactory.getLogger(ScanJarClzUtil.class);

    public static List<Class<?>> getJarClass(List<String> compileClasspathElements, String classpath, ClassLoader classLoader) {
        ArrayList jarClass = new ArrayList();
        try {
            for (String jarPath : compileClasspathElements) {
                if (!jarPath.endsWith(".jar") || !jarPath.contains(classpath)) continue;
                JarFile jarFile = new JarFile(jarPath);
                Enumeration<JarEntry> enu = jarFile.entries();
                while (enu.hasMoreElements()) {
                    String name;
                    JarEntry jarEntry = enu.nextElement();
                    if (jarEntry == null || !(name = jarEntry.getName()).endsWith(".class")) continue;
                    try {
                        String className = name.substring(0, name.lastIndexOf(".")).replace("/", ".");
                        Class<?> myclass = classLoader.loadClass(className);
                        jarClass.add(myclass);
                    }
                    catch (Throwable e) {
                        log.warn("could not load class {}, reason: Class not found {}", (Object)name, (Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jarClass;
    }
}

