/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.starter;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.dtyunxi.cube.notifier.starter.publisher.nacos.NacosPublisherProxy;
import com.dtyunxi.cube.notifier.starter.refresher.nacos.NacosConfig;
import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.nacos.config.enabled"}, havingValue="true", matchIfMissing=true)
public class NacosAutoConfiguration {
    @Bean
    public NacosConfig nacosConfig() {
        return new NacosConfig();
    }

    @Bean
    @ConditionalOnMissingBean(value={NacosPublisherProxy.class})
    public NacosPublisherProxy nacosPublisherProxy() {
        return new NacosPublisherProxy();
    }

    @Bean
    public ConfigService configService(NacosConfig nacosConfig) throws Exception {
        return ConfigFactory.createConfigService((Properties)nacosConfig.getProperties());
    }
}

