/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.starter.publisher.nacos;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.config.ConfigService;
import com.dtyunxi.cube.notifier.starter.publisher.AbstractPublisher;
import com.dtyunxi.cube.notifier.starter.publisher.nacos.INacosRuleId;
import com.dtyunxi.cube.notifier.starter.publisher.nacos.NacosPublisherProxy;
import com.dtyunxi.cube.notifier.starter.publisher.nacos.NacosRule;
import com.dtyunxi.cube.notifier.starter.refresher.nacos.NacosConfig;
import com.dtyunxi.cube.notifier.starter.rule.IRulePublisherChannel;
import com.dtyunxi.cube.notifier.starter.rule.RulePublisherChannelEnum;
import com.dtyunxi.cube.notifier.utils.NacosConfigUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public abstract class AbstractNacosPublisher<RULE>
extends AbstractPublisher<RULE>
implements INacosRuleId {
    protected NacosConfig nacosConfig;
    protected ConfigService configService;
    protected NacosPublisherProxy<RULE> publisher;

    public AbstractNacosPublisher(ConfigService configService, NacosConfig nacosConfig) {
        this.configService = configService;
        this.nacosConfig = nacosConfig;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
        if (this.publisher == null) {
            this.publisher = (NacosPublisherProxy)this.applicationContext.getBean(NacosPublisherProxy.class);
        }
        if (this.publisher != null) {
            LOGGER.info("\u6ce8\u518cnacos\u6e20\u9053\u53d1\u5e03\u5668:{}", (Object)this.key());
            this.publisher.register(this);
        }
    }

    protected void check(RULE rules) {
        AssertUtil.notEmpty((String)this.nacosConfig.getGatewayApplicationName(), (String)"app name cannot be empty");
        if (rules == null) {
            LOGGER.warn("\u89c4\u5219\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u53d1\u5e03\u52a8\u4f5c");
            return;
        }
    }

    @Override
    public void publish(RULE rules) throws Exception {
        this.check(rules);
        if (this.wrapp()) {
            NacosRule nacosRule = new NacosRule(JSONObject.toJSONString(rules));
            this.configService.publishConfig(NacosConfigUtil.getFinalDataId((String)this.nacosConfig.getGatewayApplicationName(), (String)this.getDataId()), this.getGroupId(), JSONObject.toJSONString((Object)nacosRule));
        } else {
            this.configService.publishConfig(NacosConfigUtil.getFinalDataId((String)this.nacosConfig.getGatewayApplicationName(), (String)this.getDataId()), this.getGroupId(), JSONObject.toJSONString(rules));
        }
    }

    @Override
    public String getGroupId() {
        return "DEFAULT_GROUP";
    }

    @Override
    public IRulePublisherChannel rulePublisherChannel() {
        return RulePublisherChannelEnum.NACOS;
    }

    public boolean wrapp() {
        return true;
    }
}

