/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.starter.publisher.rest.event;

import com.dtyunxi.cube.notifier.starter.publisher.rest.event.RetryRefreshEvent;
import com.dtyunxi.rest.RestResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

@RefreshScope
public class RefreshEventsListener
implements ApplicationListener<RetryRefreshEvent>,
ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(RefreshEventsListener.class);
    private ApplicationContext applicationContext;
    @Value(value="${notifyAfterRefresh.times.limit:3}")
    private int limits;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(RetryRefreshEvent refreshEvent) {
        CompletableFuture.runAsync(() -> {
            logger.info("\u91cd\u8bd5\u5237\u65b0\u76d1\u542c\u6536\u5230\u4fe1\u606f");
            if (refreshEvent.getTimes() <= this.limits) {
                int INTERVAL = 1000;
                try {
                    Thread.sleep(1000 * refreshEvent.getTimes());
                    CompletableFuture<RestResponse> result = CompletableFuture.supplyAsync(() -> refreshEvent.getCallBack().onEvent(refreshEvent.getFeignApi()));
                    try {
                        if (!"0".equals(result.get())) {
                            this.applicationContext.publishEvent(new RetryRefreshEvent(this, refreshEvent.getFeignApi(), refreshEvent.getCallBack(), refreshEvent.getTimes() + 1));
                        }
                    }
                    catch (InterruptedException e) {
                        logger.warn("\u6536\u96c6\u914d\u7f6e\u5237\u65b0\u901a\u77e5\u7ed3\u679c\u8fdb\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff1a", (Throwable)e);
                        this.applicationContext.publishEvent(new RetryRefreshEvent(this, refreshEvent.getFeignApi(), refreshEvent.getCallBack(), refreshEvent.getTimes() + 1));
                    }
                    catch (ExecutionException e) {
                        logger.warn("\u6536\u96c6\u914d\u7f6e\u5237\u65b0\u901a\u77e5\u7ed3\u679c\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
                        this.applicationContext.publishEvent(new RetryRefreshEvent(this, refreshEvent.getFeignApi(), refreshEvent.getCallBack(), refreshEvent.getTimes() + 1));
                    }
                }
                catch (InterruptedException e) {
                    logger.warn("rest\u901a\u77e5\u8bf7\u6c42\u91cd\u8bd5\u7ebf\u7a0b\u4f11\u7720\u4e2d\u65ad\u5f02\u5e38", (Throwable)e);
                }
            } else {
                logger.warn("\u91cd\u65b0\u5237\u65b0{}\u6b21\u5931\u8d25", (Object)this.limits);
            }
        });
    }
}

